/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.elasticbeanstalk;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest;
import jp.classmethod.aws.gradle.elasticbeanstalk.AwsBeanstalkPluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSElasticBeanstalkCreateApplicationTask
extends ConventionTask {
    private String appName;
    private String appDesc = "";

    public AWSElasticBeanstalkCreateApplicationTask() {
        this.setDescription("Create/Migrate ElasticBeanstalk Application.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createApplication() {
        String appName = this.getAppName();
        String appDesc = this.getAppDesc();
        AwsBeanstalkPluginExtension ext = (AwsBeanstalkPluginExtension)this.getProject().getExtensions().getByType(AwsBeanstalkPluginExtension.class);
        AWSElasticBeanstalk eb = (AWSElasticBeanstalk)ext.getClient();
        DescribeApplicationsResult existingApps = eb.describeApplications(new DescribeApplicationsRequest().withApplicationNames(new String[]{appName}));
        if (existingApps.getApplications().isEmpty()) {
            eb.createApplication(new CreateApplicationRequest().withApplicationName(appName).withDescription(appDesc));
            this.getLogger().info("application " + appName + " (" + appDesc + ") created");
        } else {
            eb.updateApplication(new UpdateApplicationRequest().withApplicationName(appName).withDescription(appDesc));
            this.getLogger().info("application " + appName + " (" + appDesc + ") updated");
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppDesc() {
        return this.appDesc;
    }

    public void setAppDesc(String appDesc) {
        this.appDesc = appDesc;
    }
}

