/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ecr;

import com.amazonaws.services.ecr.AmazonECR;
import com.amazonaws.services.ecr.model.DeleteRepositoryRequest;
import com.amazonaws.services.ecr.model.DeleteRepositoryResult;
import com.amazonaws.services.ecr.model.Repository;
import com.google.common.base.MoreObjects;
import jp.classmethod.aws.gradle.ecr.AmazonECRPluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonECRDeleteRepositoryTask
extends ConventionTask {
    private String repositoryName;
    private Repository repository;

    public AmazonECRDeleteRepositoryTask() {
        this.setDescription("Delete ECR repository");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createRepository() {
        AmazonECRPluginExtension ext = (AmazonECRPluginExtension)this.getProject().getExtensions().getByType(AmazonECRPluginExtension.class);
        AmazonECR ecr = (AmazonECR)ext.getClient();
        String repositoryName = (String)MoreObjects.firstNonNull((Object)this.getRepositoryName(), (Object)ext.getRepositoryName());
        DeleteRepositoryResult result = ecr.deleteRepository(new DeleteRepositoryRequest().withRepositoryName(repositoryName));
        this.repository = result.getRepository();
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public Repository getRepository() {
        return this.repository;
    }
}

