/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import java.util.ArrayList;
import java.util.List;
import jp.classmethod.aws.gradle.ec2.AmazonEC2PluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonEC2TerminateInstanceTask
extends ConventionTask {
    private List<String> instanceIds = new ArrayList<String>();
    private TerminateInstancesResult terminateInstancesResult;

    public AmazonEC2TerminateInstanceTask() {
        this.setDescription("Stop EC2 instance.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void terminateInstance() {
        List<String> instanceIds = this.getInstanceIds();
        if (instanceIds.isEmpty()) {
            return;
        }
        AmazonEC2PluginExtension ext = (AmazonEC2PluginExtension)this.getProject().getExtensions().getByType(AmazonEC2PluginExtension.class);
        AmazonEC2 ec2 = (AmazonEC2)ext.getClient();
        this.terminateInstancesResult = ec2.terminateInstances(new TerminateInstancesRequest(instanceIds));
        this.getLogger().info("Terminate EC2 instance {} requested", instanceIds);
    }

    public List<String> getInstanceIds() {
        return this.instanceIds;
    }

    public void setInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public TerminateInstancesResult getTerminateInstancesResult() {
        return this.terminateInstancesResult;
    }
}

