/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.services.ec2.model.StopInstancesResult;
import java.util.ArrayList;
import java.util.List;
import jp.classmethod.aws.gradle.ec2.AmazonEC2PluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonEC2StopInstanceTask
extends ConventionTask {
    private List<String> instanceIds = new ArrayList<String>();
    private StopInstancesResult stopInstancesResult;

    public AmazonEC2StopInstanceTask() {
        this.setDescription("Stop EC2 instance.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void stopInstance() {
        List<String> instanceIds = this.getInstanceIds();
        if (instanceIds.isEmpty()) {
            return;
        }
        AmazonEC2PluginExtension ext = (AmazonEC2PluginExtension)this.getProject().getExtensions().getByType(AmazonEC2PluginExtension.class);
        AmazonEC2 ec2 = (AmazonEC2)ext.getClient();
        this.stopInstancesResult = ec2.stopInstances(new StopInstancesRequest(instanceIds));
        this.getLogger().info("Stop EC2 instance {} requested", instanceIds);
    }

    public List<String> getInstanceIds() {
        return this.instanceIds;
    }

    public void setInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public StopInstancesResult getStopInstancesResult() {
        return this.stopInstancesResult;
    }
}

