/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.StartInstancesRequest;
import com.amazonaws.services.ec2.model.StartInstancesResult;
import java.util.ArrayList;
import java.util.List;
import jp.classmethod.aws.gradle.ec2.AmazonEC2PluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonEC2StartInstanceTask
extends ConventionTask {
    private List<String> instanceIds = new ArrayList<String>();
    private StartInstancesResult startInstancesResult;

    public AmazonEC2StartInstanceTask() {
        this.setDescription("Start EC2 instance.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void startInstance() {
        List<String> instanceIds = this.getInstanceIds();
        if (instanceIds.isEmpty()) {
            return;
        }
        AmazonEC2PluginExtension ext = (AmazonEC2PluginExtension)this.getProject().getExtensions().getByType(AmazonEC2PluginExtension.class);
        AmazonEC2 ec2 = (AmazonEC2)ext.getClient();
        this.startInstancesResult = ec2.startInstances(new StartInstancesRequest(instanceIds));
        this.getLogger().info("Start EC2 instance {} requested", instanceIds);
    }

    public List<String> getInstanceIds() {
        return this.instanceIds;
    }

    public void setInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public StartInstancesResult getStartInstancesResult() {
        return this.startInstancesResult;
    }
}

