/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ec2;

import com.amazonaws.services.ec2.model.IpPermission;
import groovy.lang.GString;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jp.classmethod.aws.gradle.ec2.ParseException;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;

abstract class AbstractAmazonEC2SecurityGroupPermissionTask
extends ConventionTask {
    AbstractAmazonEC2SecurityGroupPermissionTask() {
    }

    protected Collection<IpPermission> parse(Object e) {
        if (e instanceof IpPermission) {
            return Collections.singleton((IpPermission)e);
        }
        Set<Object> elements = e instanceof Collection ? (Set<Object>)e : Collections.singleton(e);
        return elements.stream().map(it -> {
            if (it instanceof IpPermission) {
                return (IpPermission)it;
            }
            if (it instanceof String || it instanceof GString) {
                int fromPort;
                int toPort;
                String protocol;
                String expression = it.toString();
                if (!expression.contains(":")) {
                    throw new ParseException(expression);
                }
                String[] expressions = expression.split(":", 2);
                String protocolAndPortExpression = expressions[0];
                String rangeExpression = expressions[1];
                if ("icmp".equalsIgnoreCase(protocolAndPortExpression)) {
                    protocol = protocolAndPortExpression;
                    toPort = -1;
                    fromPort = -1;
                } else if (!protocolAndPortExpression.contains("/")) {
                    protocol = protocolAndPortExpression;
                    fromPort = 0;
                    toPort = 65535;
                } else {
                    String[] protocolAndPortExpressions = protocolAndPortExpression.split("/", 2);
                    protocol = protocolAndPortExpressions[0];
                    String portExpression = protocolAndPortExpressions[1];
                    if (portExpression.contains("-")) {
                        String[] ports = portExpression.split("-", 2);
                        fromPort = Integer.parseInt(ports[0]);
                        toPort = Integer.parseInt(ports[1]);
                    } else {
                        fromPort = toPort = Integer.parseInt(portExpression);
                    }
                }
                List<String> ranges = Arrays.asList(rangeExpression.split(","));
                return new IpPermission().withIpProtocol(protocol).withFromPort(Integer.valueOf(fromPort)).withToPort(Integer.valueOf(toPort)).withIpRanges(ranges);
            }
            throw new GradleException("ipPermission type only supports IpPermission or String: " + it.getClass());
        }).collect(Collectors.toList());
    }
}

