/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudwatch;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.Datapoint;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jp.classmethod.aws.gradle.cloudwatch.AwsCloudWatchPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AwsCloudWatchGetMetricStatisticsTask
extends ConventionTask {
    private String metricName;
    private String namespace;
    private Integer period;
    private String statistics;
    private String extendedStatistics;
    private Map<String, String> dimensions;
    private Date startTime;
    private Date endTime;
    private String unit;
    private List<Datapoint> datapoints;
    private String label;

    public AwsCloudWatchGetMetricStatisticsTask() {
        this.setDescription("List CloudWatch metric statistics.");
        this.setGroup("AWS");
    }

    public GetMetricStatisticsResult getMetricStatistics(String metricName, String namespace, String statistics, String extendedStatistics, String unit) throws AmazonServiceException {
        AwsCloudWatchPluginExtension ext = (AwsCloudWatchPluginExtension)this.getProject().getExtensions().getByType(AwsCloudWatchPluginExtension.class);
        AmazonCloudWatch cw = (AmazonCloudWatch)ext.getClient();
        GetMetricStatisticsRequest request = new GetMetricStatisticsRequest().withMetricName(metricName).withNamespace(namespace).withStatistics(new String[]{statistics}).withExtendedStatistics(new String[]{extendedStatistics}).withUnit(unit).withEndTime(this.getEndTime()).withStartTime(this.getStartTime()).withPeriod(this.getPeriod());
        if (this.getDimensions() != null) {
            request.withDimensions((Collection)this.getDimensions().entrySet().stream().map(it -> new Dimension().withName(((String)it.getKey()).toString()).withValue((String)it.getValue())).collect(Collectors.toList()));
        }
        GetMetricStatisticsResult response = cw.getMetricStatistics(request);
        for (Datapoint metric : response.getDatapoints()) {
            this.getLogger().debug("Retrieved metric %s", (Object)metric.getAverage());
        }
        return response;
    }

    @TaskAction
    public void getMetricStatistics() {
        try {
            GetMetricStatisticsResult result = this.getMetricStatistics(this.getMetricName(), this.getNamespace(), this.getStatistics(), this.getExtendedStatistics(), this.getUnit());
            this.datapoints = result.getDatapoints();
            this.label = result.getLabel();
        }
        catch (AmazonServiceException e) {
            throw new GradleException("Fail to describe metric: " + this.getMetricName(), (Throwable)e);
        }
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public String getStatistics() {
        return this.statistics;
    }

    public void setStatistics(String statistics) {
        this.statistics = statistics;
    }

    public String getExtendedStatistics() {
        return this.extendedStatistics;
    }

    public void setExtendedStatistics(String extendedStatistics) {
        this.extendedStatistics = extendedStatistics;
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public List<Datapoint> getDatapoints() {
        return this.datapoints;
    }

    public String getLabel() {
        return this.label;
    }
}

