/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.SetStackPolicyRequest;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationPluginExtension;
import org.apache.commons.io.FileUtils;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonCloudFormationStackPolicyTask
extends ConventionTask {
    private String stackName;
    private String cfnStackPolicyUrl;
    private File cfnStackPolicyFile;

    public AmazonCloudFormationStackPolicyTask() {
        this.setDescription("Set CloudFormation policy");
        this.setGroup("AWS");
    }

    @TaskAction
    public void setStackPolicy() throws IOException {
        AmazonCloudFormationPluginExtension ext = (AmazonCloudFormationPluginExtension)this.getProject().getExtensions().getByType(AmazonCloudFormationPluginExtension.class);
        AmazonCloudFormation cfn = (AmazonCloudFormation)ext.getClient();
        String stackName = this.getStackName();
        String cfnStackPolicyUrl = this.getCfnStackPolicyUrl();
        File cfnStackPolicyFile = this.getCfnStackPolicyFile();
        SetStackPolicyRequest request = new SetStackPolicyRequest().withStackName(stackName);
        if (!Strings.isNullOrEmpty((String)cfnStackPolicyUrl)) {
            request.setStackPolicyURL(cfnStackPolicyUrl);
            this.getLogger().info(String.format(Locale.ENGLISH, "Setting stack policy for stack %s using URL %s", stackName, cfnStackPolicyUrl));
        } else if (cfnStackPolicyFile != null) {
            request.setStackPolicyBody(FileUtils.readFileToString((File)cfnStackPolicyFile));
            this.getLogger().info(String.format(Locale.ENGLISH, "Setting stack policy for stack " + stackName + " using file " + cfnStackPolicyFile, new Object[0]));
        }
        cfn.setStackPolicy(request);
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public String getCfnStackPolicyUrl() {
        return this.cfnStackPolicyUrl;
    }

    public void setCfnStackPolicyUrl(String cfnStackPolicyUrl) {
        this.cfnStackPolicyUrl = cfnStackPolicyUrl;
    }

    public File getCfnStackPolicyFile() {
        return this.cfnStackPolicyFile;
    }

    public void setCfnStackPolicyFile(File cfnStackPolicyFile) {
        this.cfnStackPolicyFile = cfnStackPolicyFile;
    }
}

