/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.ChangeSetSummary;
import com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest;
import com.amazonaws.services.cloudformation.model.DescribeChangeSetResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest;
import com.amazonaws.services.cloudformation.model.Stack;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationPluginExtension;
import jp.classmethod.aws.gradle.cloudformation.ChangeSetFetcher;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonCloudFormationExecuteChangeSetTask
extends ConventionTask {
    String stackName;
    private List<String> stableStatuses = Arrays.asList("CREATE_COMPLETE", "REVIEW_IN_PROGRESS", "ROLLBACK_COMPLETE", "UPDATE_COMPLETE", "UPDATE_ROLLBACK_COMPLETE");

    public AmazonCloudFormationExecuteChangeSetTask() {
        this.setDescription("Execute the latest cfn change set.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void executeChangeSet() throws InterruptedException, IOException {
        String stackName = this.getStackName();
        if (stackName == null) {
            throw new GradleException("stackName is not specified");
        }
        AmazonCloudFormationPluginExtension ext = (AmazonCloudFormationPluginExtension)this.getProject().getExtensions().getByType(AmazonCloudFormationPluginExtension.class);
        AmazonCloudFormation cfn = (AmazonCloudFormation)ext.getClient();
        try {
            String changeSetName;
            DescribeStacksResult describeStackResult = cfn.describeStacks(new DescribeStacksRequest().withStackName(stackName));
            Stack stack = (Stack)describeStackResult.getStacks().get(0);
            if (this.stableStatuses.contains(stack.getStackStatus())) {
                Optional<ChangeSetSummary> summary = new ChangeSetFetcher(cfn).getLatestChangeSetSummary(stackName);
                changeSetName = summary.orElseThrow(() -> new GradleException("ChangeSet for stack " + stackName + " was not found.")).getChangeSetName();
                if (this.isNoUpdateRequired(cfn, stackName, changeSetName)) {
                    return;
                }
            } else {
                throw new GradleException("invalid status for update: " + stack.getStackStatus());
            }
            ExecuteChangeSetRequest req = new ExecuteChangeSetRequest().withStackName(stackName).withChangeSetName(changeSetName);
            cfn.executeChangeSet(req);
            this.getLogger().info("ChangeSet is executed : {}, {}", (Object)stackName, (Object)changeSetName);
        }
        catch (AmazonServiceException e) {
            if (e.getMessage().contains("does not exist")) {
                this.getLogger().warn("stack {} not found", (Object)stackName);
            }
            throw e;
        }
    }

    private boolean isNoUpdateRequired(AmazonCloudFormation cfn, String stackName, String changeSetName) {
        DescribeChangeSetRequest describeChangeSetRequest = new DescribeChangeSetRequest().withChangeSetName(changeSetName).withStackName(stackName);
        DescribeChangeSetResult describeChangeSetResult = cfn.describeChangeSet(describeChangeSetRequest);
        if ("FAILED".equals(describeChangeSetResult.getStatus()) && describeChangeSetResult.getChanges().isEmpty()) {
            this.getLogger().info("No updates to be performed.");
            return true;
        }
        return false;
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }
}

