/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.messaging.core.impl;

/**
 *
 * A RotatingID
 *
 * 64 bits, made up of:
 *
 * First 8 bits - node id
 * Next 42 bits - lowest 41 bits of system time
 * Next 14 bits - rotating counter
 *
 * @author <a href="mailto:tim.fox@jboss.com">Tim Fox</a>
 *
 */
public class RotatingID
{
   private short count;

   private long lastTime = System.currentTimeMillis();

   private final long nodeID;

   public RotatingID(final int nodeID)
   {
      if (nodeID < 0 || nodeID > 255)
      {
         throw new IllegalArgumentException("node id must be between 0 to 255 inclusive");
      }

      this.nodeID = nodeID;
   }

   public synchronized long getID()
   {
      long id1 = nodeID << 54;

      long id2 = System.currentTimeMillis() << 14;

      long id = id1 | id2 | count;

      if (count == Short.MAX_VALUE)
      {
         count = 0;

         long now = System.currentTimeMillis();

         //Safety - not likely to happen

         while (now == lastTime)
         {
            try
            {
               Thread.sleep(1);
            }
            catch (InterruptedException e)
            {}

            now = System.currentTimeMillis();
         }

         lastTime = now;
      }
      else
      {
         count++;
      }

      return id;
   }
}