/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.messaging.core.contract;

import org.jboss.messaging.core.impl.tx.Transaction;

/**
 * A message delivery. It can be "done" or active.
 * 
 * @author <a href="mailto:ovidiu@feodorov.com">Ovidiu Feodorov</a>
 * @author <a href="mailto:tim.fox@jboss.com">Tim Fox</a>
 * @version <tt>$Revision: 5505 $</tt>
 *
 * $Id: Delivery.java 5505 2008-12-10 14:32:06Z gaohoward $
 */
public interface Delivery
{
   MessageReference getReference();

   DeliveryObserver getObserver();

   // TODO this doesn't actually belong in the delivery, the selector should be moved "inside"
   //      the channel. See http://jira.jboss.org/jira/browse/JBMESSAGING-275

   boolean isSelectorAccepted();
   
   void acknowledge(Transaction tx) throws Throwable;

   void cancel() throws Throwable;   
   
   boolean isRecovered();

   /**
    * Mark if this delivery is with a prepared XA transaction.
    */
   boolean isXAPrepared();
}
