/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.jms.referenceable;

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

import org.jboss.jms.client.JBossConnectionFactory;

/**
 * 
 * A ConnectionFactoryObjectFactory.
 * 
 * Given a reference - reconstructs a JBossConnectionFactory
 * 
 * @author <a href="tim.fox@jboss.com">Tim Fox</a>
 * @version $Revision: 958 $
 *
 * $Id: ConnectionFactoryObjectFactory.java 958 2006-05-18 01:51:15Z ovidiu $
 */
public class ConnectionFactoryObjectFactory implements ObjectFactory
{
   public Object getObjectInstance(Object ref, Name name, Context ctx,
                                   Hashtable props) throws Exception
   {
      Reference r = (Reference)ref;
      
      byte[] bytes = (byte[])r.get("JBM-CF").getContent();
      
      // Deserialize
      return (JBossConnectionFactory)SerializableObjectRefAddr.deserialize(bytes);
   }
}

