/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.jms.destination;

import javax.jms.JMSException;
import javax.jms.Queue;

/**
 * @author <a href="mailto:ovidiu@feodorov.com">Ovidiu Feodorov</a>
 * @version <tt>$Revision: 2977 $</tt>
 *
 * $Id: JBossQueue.java 2977 2007-08-08 15:32:14Z timfox $
 */
public class JBossQueue extends JBossDestination implements Queue
{
   // Constants -----------------------------------------------------
   
   private static final long serialVersionUID = 4121129234371655479L;

   // Static --------------------------------------------------------
   
   // Attributes ----------------------------------------------------
   
   // Constructors --------------------------------------------------

   public JBossQueue(String name)
   {
      super(name);
   }
   
   public JBossQueue(String name, boolean direct)
   {
   	super(name);
   	
   	this.direct = direct;
   }

   // JBossDestination overrides ------------------------------------

   public boolean isTopic()
   {
      return false;
   }

   public boolean isQueue()
   {
      return true;
   }

   // Queue implementation ------------------------------------------

   public String getQueueName() throws JMSException
   {
      return getName();
   }

   // Public --------------------------------------------------------
   
   public String toString()
   {
      return "JBossQueue[" + name + "]";
   }

   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------   
}
