/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.persistence.spi;

/**
 * This enum class defines whether the entity managers created by the
 * {@link javax.persistence.EntityManagerFactory} will be
 * JTA or resource-local entity managers.
 *
 * @since Java Persistence 1.0
 */
public enum PersistenceUnitTransactionType {

    /** JTA entity manager */
    JTA,

    /** resource-local entity manager */
    RESOURCE_LOCAL
}
