/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.ResponseStateManagerImpl;
import com.sun.faces.renderkit.html_basic.HtmlResponseWriter;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;

public class RenderKitImpl
extends RenderKit {
    private static final Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.renderkit");
    private HashMap<String, HashMap<Object, Renderer>> rendererFamilies = new HashMap();
    private ResponseStateManager responseStateManager = null;
    private Boolean preferXHTML;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderer(String family, String rendererType, Renderer renderer) {
        if (family == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "family");
            throw new NullPointerException(message);
        }
        if (rendererType == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "rendererType");
            throw new NullPointerException(message);
        }
        if (renderer == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "renderer");
            throw new NullPointerException(message);
        }
        HashMap<Object, Object> renderers = null;
        HashMap<String, HashMap<Object, Renderer>> hashMap = this.rendererFamilies;
        synchronized (hashMap) {
            renderers = this.rendererFamilies.get(family);
            if (null == renderers) {
                renderers = new HashMap();
                this.rendererFamilies.put(family, renderers);
            }
            renderers.put(rendererType, renderer);
        }
    }

    public Renderer getRenderer(String family, String rendererType) {
        if (rendererType == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "rendererType");
            throw new NullPointerException(message);
        }
        if (family == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "family");
            throw new NullPointerException(message);
        }
        assert (this.rendererFamilies != null);
        HashMap<Object, Renderer> renderers = null;
        Renderer renderer = null;
        renderers = this.rendererFamilies.get(family);
        if (null != renderers) {
            renderer = renderers.get(rendererType);
        }
        return renderer;
    }

    public synchronized ResponseStateManager getResponseStateManager() {
        if (this.responseStateManager == null) {
            this.responseStateManager = new ResponseStateManagerImpl();
        }
        return this.responseStateManager;
    }

    public ResponseWriter createResponseWriter(Writer writer, String desiredContentTypeList, String characterEncoding) {
        if (writer == null) {
            return null;
        }
        String contentType = null;
        boolean contentTypeNullFromResponse = false;
        FacesContext context = FacesContext.getCurrentInstance();
        String[] supportedTypes = new String[]{"text/html", "application/xhtml+xml", "application/xml", "text/xml"};
        if (this.preferXHTML == null) {
            this.preferXHTML = WebConfiguration.getInstance(context.getExternalContext()).getBooleanContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.PreferXHTMLContentType);
        }
        if (null != desiredContentTypeList) {
            contentType = this.findMatch(context, desiredContentTypeList, supportedTypes);
        }
        if (null == desiredContentTypeList && null != (desiredContentTypeList = context.getExternalContext().getResponseContentType()) && null == (contentType = this.findMatch(context, desiredContentTypeList, supportedTypes))) {
            contentTypeNullFromResponse = true;
        }
        if (null == desiredContentTypeList || contentTypeNullFromResponse) {
            String[] typeArray = (String[])context.getExternalContext().getRequestHeaderValuesMap().get("Accept");
            if (typeArray.length > 0) {
                StringBuffer buff = new StringBuffer();
                buff.append(typeArray[0]);
                for (int i = 1; i < typeArray.length; ++i) {
                    buff.append(',');
                    buff.append(typeArray[i]);
                }
                desiredContentTypeList = buff.toString();
            }
            if (null != desiredContentTypeList) {
                String supportedTypeString = "text/html,application/xhtml+xml,application/xml,text/xml";
                desiredContentTypeList = this.preferXHTML != false ? RenderKitUtils.determineContentType(desiredContentTypeList, supportedTypeString, "application/xhtml+xml") : RenderKitUtils.determineContentType(desiredContentTypeList, supportedTypeString, null);
                if (null != desiredContentTypeList) {
                    contentType = this.findMatch(context, desiredContentTypeList, supportedTypes);
                }
            }
        }
        if (null == desiredContentTypeList || "*/*".equals(desiredContentTypeList)) {
            contentType = "text/html";
        }
        if (null == contentType) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.CONTENT_TYPE_ERROR", new Object[0]));
        }
        if (characterEncoding == null) {
            characterEncoding = "ISO-8859-1";
        }
        return new HtmlResponseWriter(writer, contentType, characterEncoding);
    }

    private String[] contentTypeSplit(String contentTypeString) {
        String[] result = Util.split(contentTypeString, ",");
        for (int i = 0; i < result.length; ++i) {
            int semicolon = result[i].indexOf(";");
            if (-1 == semicolon) continue;
            result[i] = result[i].substring(0, semicolon);
        }
        return result;
    }

    private String findMatch(FacesContext context, String desiredContentTypeList, String[] supportedTypes) {
        String contentType = null;
        String[] desiredTypes = this.contentTypeSplit(desiredContentTypeList);
        String curContentType = null;
        String curDesiredType = null;
        for (int i = 0; i < desiredTypes.length; ++i) {
            curDesiredType = desiredTypes[i];
            for (int j = 0; j < supportedTypes.length; ++j) {
                curContentType = supportedTypes[j].trim();
                if (!curDesiredType.contains(curContentType)) continue;
                if (curContentType.contains("text/html")) {
                    contentType = "text/html";
                    break;
                }
                if (!curContentType.contains("application/xhtml+xml") && !curContentType.contains("application/xml") && !curContentType.contains("text/xml")) break;
                contentType = "application/xhtml+xml";
                break;
            }
            if (null != contentType) break;
        }
        return contentType;
    }

    public ResponseStream createResponseStream(OutputStream out) {
        final OutputStream output = out;
        return new ResponseStream(){

            public void write(int b) throws IOException {
                output.write(b);
            }

            public void write(byte[] b) throws IOException {
                output.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                output.write(b, off, len);
            }

            public void flush() throws IOException {
                output.flush();
            }

            public void close() throws IOException {
                output.close();
            }
        };
    }
}

