/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.JSFVersionTracker;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ViewExpiredException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.render.ResponseStateManager;
import javax.servlet.http.HttpServletRequest;

public class RestoreViewPhase
extends Phase {
    private static Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.lifecycle");
    private String contextDefaultSuffix;

    public PhaseId getId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void execute(FacesContext facesContext) throws FacesException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Entering RestoreViewPhase");
        }
        if (null == facesContext) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR", new Object[0]));
        }
        Util.getViewHandler(facesContext).initView(facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found a pre created view in FacesContext");
            }
            Locale locale = facesContext.getExternalContext().getRequestLocale();
            facesContext.getViewRoot().setLocale(locale);
            this.doPerComponentActions(facesContext, (UIComponent)viewRoot);
            return;
        }
        String viewId = this.getViewId(facesContext);
        if (viewId == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("requestPath is null");
            }
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_REQUEST_VIEW_ERROR", new Object[0]));
        }
        if (this.isPostback(facesContext)) {
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            viewRoot = viewHandler.restoreView(facesContext, viewId);
            if (null == viewRoot) {
                JSFVersionTracker tracker = ApplicationAssociate.getInstance(facesContext.getExternalContext()).getJSFVersionTracker();
                if (null != tracker) {
                    boolean stateManagerIsOld;
                    JSFVersionTracker.Version currentVersion;
                    JSFVersionTracker.Version toTest = tracker.getVersionForTrackedClassName(viewHandler.getClass().getName());
                    boolean viewHandlerIsOld = toTest.compareTo(currentVersion = tracker.getCurrentVersion()) < 0;
                    toTest = tracker.getVersionForTrackedClassName(facesContext.getApplication().getStateManager().getClass().getName());
                    boolean bl = stateManagerIsOld = toTest.compareTo(currentVersion) < 0;
                    if ((viewHandlerIsOld || stateManagerIsOld) && null != (viewRoot = viewHandler.createView(facesContext, viewId))) {
                        facesContext.renderResponse();
                    }
                }
                if (null == viewRoot) {
                    throw new ViewExpiredException(MessageUtils.getExceptionMessageString("com.sun.faces.RESTORE_VIEW_ERROR", viewId), viewId);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Postback: Restored view for " + viewId);
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("New request: creating a view for " + viewId);
            }
            viewRoot = Util.getViewHandler(facesContext).createView(facesContext, viewId);
            facesContext.renderResponse();
        }
        assert (null != viewRoot);
        facesContext.setViewRoot(viewRoot);
        this.doPerComponentActions(facesContext, (UIComponent)viewRoot);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Exiting RestoreViewPhase");
        }
    }

    private boolean isPostback(FacesContext context) {
        String renderkitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderkitId);
        return rsm.isPostback(context);
    }

    protected void doPerComponentActions(FacesContext context, UIComponent uic) {
        ValueExpression valueExpression = uic.getValueExpression("binding");
        if (null != valueExpression) {
            valueExpression.setValue(context.getELContext(), (Object)uic);
        }
        Iterator kids = uic.getFacetsAndChildren();
        while (kids.hasNext()) {
            this.doPerComponentActions(context, (UIComponent)kids.next());
        }
    }

    private String convertViewId(FacesContext context, String viewId) {
        if (viewId == null) {
            return null;
        }
        this.initDefaultSuffix(context);
        String mapping = Util.getFacesMapping(context);
        boolean isPrefixMapped = Util.isPrefixMapped(mapping);
        ExternalContext extContext = context.getExternalContext();
        if (extContext.getRequestPathInfo() == null && mapping != null && Util.isPrefixMapped(mapping)) {
            try {
                context.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Response Complete for" + viewId);
                }
                extContext.redirect(extContext.getRequestContextPath());
            }
            catch (IOException ioe) {
                throw new FacesException((Throwable)ioe);
            }
        }
        String convertedViewId = null;
        if (mapping != null && !isPrefixMapped) {
            if (!viewId.endsWith(this.contextDefaultSuffix)) {
                StringBuffer buffer = new StringBuffer(viewId);
                int extIdx = viewId.lastIndexOf(46);
                if (extIdx != -1) {
                    buffer.replace(extIdx, viewId.length(), this.contextDefaultSuffix);
                } else {
                    buffer.append(this.contextDefaultSuffix);
                }
                convertedViewId = buffer.toString();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("viewId after appending the context suffix " + convertedViewId);
                }
            }
        } else {
            convertedViewId = viewId.substring(viewId.indexOf(mapping) + 1);
        }
        return convertedViewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDefaultSuffix(FacesContext context) {
        if (this.contextDefaultSuffix == null) {
            RestoreViewPhase restoreViewPhase = this;
            synchronized (restoreViewPhase) {
                if (this.contextDefaultSuffix == null) {
                    this.contextDefaultSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
                    if (this.contextDefaultSuffix == null) {
                        this.contextDefaultSuffix = ".jsp";
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("contextDefaultSuffix " + this.contextDefaultSuffix);
                    }
                }
            }
        }
    }

    private String getViewId(FacesContext context) {
        Object request;
        Map requestMap = context.getExternalContext().getRequestMap();
        String requestPath = (String)requestMap.get("javax.servlet.include.path_info");
        if (requestPath == null) {
            requestPath = context.getExternalContext().getRequestPathInfo();
        }
        if (requestPath == null) {
            requestPath = (String)requestMap.get("javax.servlet.include.servlet_path");
        }
        if (requestPath == null && (request = context.getExternalContext().getRequest()) instanceof HttpServletRequest) {
            requestPath = ((HttpServletRequest)request).getServletPath();
        }
        return this.convertViewId(context, requestPath);
    }
}

