/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;

public class RenderResponsePhase
extends Phase {
    private static Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.lifecycle");

    public PhaseId getId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void execute(FacesContext facesContext) throws FacesException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Entering RenderResponsePhase");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("About to render view " + facesContext.getViewRoot().getViewId());
        }
        try {
            Set clientIds;
            Iterator clientIdIter;
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            if (logger.isLoggable(Level.INFO) && (clientIdIter = facesContext.getClientIdsWithMessages()).hasNext()) {
                HashSet clientIds2 = new HashSet();
                while (clientIdIter.hasNext()) {
                    clientIds2.add(clientIdIter.next());
                }
                requestMap.put("com.sun.faces.clientIdMessagesNotDisplayed", clientIds2);
            }
            facesContext.getApplication().getViewHandler().renderView(facesContext, facesContext.getViewRoot());
            if (logger.isLoggable(Level.INFO) && requestMap.containsKey("com.sun.faces.clientIdMessagesNotDisplayed") && !(clientIds = (Set)requestMap.remove("com.sun.faces.clientIdMessagesNotDisplayed")).isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (String clientId : clientIds) {
                    Iterator messages = facesContext.getMessages(clientId);
                    while (messages.hasNext()) {
                        FacesMessage message = (FacesMessage)messages.next();
                        builder.append("\n");
                        builder.append("sourceId=" + clientId);
                        builder.append("[severity=(" + message.getSeverity());
                        builder.append("), summary=(" + message.getSummary());
                        builder.append("), detail=(" + message.getDetail() + ")]");
                    }
                }
                logger.log(Level.INFO, "jsf.non_displayed_message", builder.toString());
            }
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Exiting RenderResponsePhase");
        }
    }
}

