/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;

class ApplicationMap
extends BaseContextMap {
    private final ServletContext servletContext;

    ApplicationMap(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void clear() {
        String name = null;
        Enumeration e = this.servletContext.getAttributeNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            this.servletContext.removeAttribute(name);
        }
    }

    public void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.servletContext.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.servletContext.getAttribute(key.toString());
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        String keyString = key.toString();
        Object result = this.servletContext.getAttribute(keyString);
        this.servletContext.setAttribute(keyString, value);
        return result;
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        String keyString = key.toString();
        Object result = this.servletContext.getAttribute(keyString);
        this.servletContext.removeAttribute(keyString);
        return result;
    }

    public boolean containsKey(Object key) {
        return this.servletContext.getAttribute(key.toString()) != null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ApplicationMap)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hashCode = 7 * this.servletContext.hashCode();
        Iterator<? extends Object> i = this.entrySet().iterator();
        while (i.hasNext()) {
            hashCode += i.next().hashCode();
        }
        return hashCode;
    }

    protected Iterator getEntryIterator() {
        return new BaseContextMap.EntryIterator(this, this.servletContext.getAttributeNames());
    }

    protected Iterator getKeyIterator() {
        return new BaseContextMap.KeyIterator(this, this.servletContext.getAttributeNames());
    }

    protected Iterator getValueIterator() {
        return new BaseContextMap.ValueIterator(this, this.servletContext.getAttributeNames());
    }
}

