/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.ConfigureListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFVersionTracker {
    private static Version DEFAULT_VERSION;
    private static final Logger LOGGER;
    private Map<String, Version> grammarToVersionMap = null;
    private List<Version> versionStack;
    private Map<String, Version> trackedClasses;

    JSFVersionTracker() {
        DEFAULT_VERSION = new Version(1, 2);
    }

    private Map<String, Version> getGrammarToVersionMap() {
        if (null == this.grammarToVersionMap) {
            this.grammarToVersionMap = new HashMap<String, Version>(6);
            this.grammarToVersionMap.put("web-facesconfig_1_0.dtd", new Version(1, 0));
            this.grammarToVersionMap.put("web-facesconfig_1_1.dtd", new Version(1, 1));
            this.grammarToVersionMap.put("web-facesconfig_1_2.xsd", new Version(1, 2));
        }
        return this.grammarToVersionMap;
    }

    private List<Version> getVersionStack() {
        if (null == this.versionStack) {
            this.versionStack = new ArrayList<Version>(){

                @Override
                public String toString() {
                    StringBuffer result = new StringBuffer();
                    for (Version cur : this) {
                        if (null == cur) {
                            result.append("null\n");
                            continue;
                        }
                        result.append(cur.toString() + "\n");
                    }
                    return result.toString();
                }
            };
        }
        return this.versionStack;
    }

    Version popJSFVersionNumber() {
        List<Version> stack = this.getVersionStack();
        assert (null != stack);
        int nonNull = -1;
        int j = 0;
        int end = 0;
        Version result = null;
        for (nonNull = end = stack.size() - 1; nonNull >= 0 && null == (result = stack.get(nonNull)); --nonNull) {
        }
        if (null != result) {
            for (j = end; j >= nonNull; --j) {
                stack.remove(stack.size() - 1);
            }
        }
        return result;
    }

    Version peekJSFVersionNumber() {
        List<Version> stack = this.getVersionStack();
        assert (null != stack);
        int i = -1;
        boolean j = false;
        int end = stack.size() - 1;
        Version result = null;
        for (i = end; i >= 0 && null == (result = stack.get(i)); --i) {
        }
        return result;
    }

    private Map<String, Version> getTrackedClassMap() {
        if (null == this.trackedClasses) {
            this.trackedClasses = new HashMap<String, Version>(){

                @Override
                public String toString() {
                    StringBuffer result = new StringBuffer();
                    Version curVersion = null;
                    for (Map.Entry cur : this.entrySet()) {
                        curVersion = (Version)cur.getValue();
                        result.append(cur + ": " + curVersion.toString() + "\n");
                    }
                    return result.toString();
                }
            };
        }
        return this.trackedClasses;
    }

    void startParse() {
    }

    void endParse() {
        this.popJSFVersionNumber();
    }

    String pushJSFVersionNumberFromGrammar(String grammar) {
        Map<String, Version> map = this.getGrammarToVersionMap();
        List<Version> stack = this.getVersionStack();
        assert (null != map);
        assert (null != stack);
        stack.add(map.get(grammar));
        return grammar;
    }

    void putTrackedClassName(String fqcn) {
        Version version = this.peekJSFVersionNumber();
        if (null == version) {
            version = DEFAULT_VERSION;
        }
        this.getTrackedClassMap().put(fqcn, version);
    }

    void publishInstanceToApplication() {
        ExternalContext extContext = ConfigureListener.getExternalContextDuringInitialize();
        ApplicationAssociate associate = null;
        if (null != extContext && null != (associate = ApplicationAssociate.getInstance(extContext))) {
            associate.setJSFVersionTracker(this);
        }
    }

    public Version getVersionForTrackedClassName(String fqcn) {
        return this.getTrackedClassMap().get(fqcn);
    }

    public Version getCurrentVersion() {
        return DEFAULT_VERSION;
    }

    static {
        LOGGER = Logger.getLogger("javax.enterprise.resource.webcontainer.jsf.config", "com.sun.faces.LogStrings");
    }

    public final class Version
    implements Comparable {
        private int majorVersion;
        private int minorVersion;

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public void setMajorVersion(int majorVersion) {
            this.majorVersion = majorVersion;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        public void setMinorVersion(int minorVersion) {
            this.minorVersion = minorVersion;
        }

        public int compareTo(Object obj) {
            int otherMajor;
            Version other = (Version)obj;
            int result = 0;
            int thisMajor = this.getMajorVersion();
            if (thisMajor < (otherMajor = other.getMajorVersion())) {
                result = -1;
            } else {
                assert (thisMajor >= otherMajor);
                if (thisMajor == otherMajor) {
                    int otherMinor;
                    int thisMinor = this.getMinorVersion();
                    if (thisMinor < (otherMinor = other.getMinorVersion())) {
                        result = -1;
                    } else {
                        assert (thisMinor >= otherMinor);
                        result = thisMinor == otherMinor ? 1 : 0;
                    }
                } else {
                    assert (thisMajor > otherMajor);
                    result = 1;
                }
            }
            return result;
        }

        public Version(int majorVersion, int minorVersion) {
            this.setMajorVersion(majorVersion);
            this.setMinorVersion(minorVersion);
        }

        public String toString() {
            return "" + this.getMajorVersion() + "." + this.getMinorVersion();
        }
    }
}

