/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ViewHandlerResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayServletOutputStream basos = null;
    private PrintWriter pw = null;
    private CharArrayWriter caw = null;
    private int status = 200;

    public ViewHandlerResponseWrapper(HttpServletResponse wrapped) {
        super(wrapped);
    }

    public void sendError(int sc, String msg) throws IOException {
        super.sendError(sc, msg);
        this.status = sc;
    }

    public void sendError(int sc) throws IOException {
        super.sendError(sc);
        this.status = sc;
    }

    public void setStatus(int sc) {
        super.setStatus(sc);
        this.status = sc;
    }

    public void setStatus(int sc, String sm) {
        super.setStatus(sc, sm);
        this.status = sc;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isBytes() {
        return null != this.basos;
    }

    public boolean isChars() {
        return null != this.caw;
    }

    public byte[] getBytes() {
        byte[] result = null;
        if (null != this.basos) {
            result = this.basos.toByteArray();
        }
        return result;
    }

    public char[] getChars() {
        char[] result = null;
        if (null != this.caw) {
            result = this.caw.toCharArray();
        }
        return result;
    }

    public String toString() {
        String result = null;
        if (null != this.caw) {
            result = this.caw.toString();
        } else if (null != this.basos) {
            result = this.basos.toString();
        }
        return result;
    }

    public void flushContentToWrappedResponse() throws IOException {
        ServletResponse wrapped = this.getResponse();
        if (null != this.caw) {
            wrapped.getWriter().print(this.caw.toCharArray());
            this.pw.flush();
            this.caw.reset();
        } else if (null != this.basos) {
            wrapped.getOutputStream().write(this.basos.toByteArray());
            this.basos.flush();
            this.basos.resetByteArray();
        }
    }

    public void clearWrappedResponse() throws IOException {
        if (null != this.caw) {
            this.caw.reset();
        } else if (null != this.basos) {
            this.basos.resetByteArray();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (null == this.basos) {
            this.basos = new ByteArrayServletOutputStream();
        }
        return this.basos;
    }

    public PrintWriter getWriter() throws IOException {
        if (null == this.pw) {
            this.caw = new CharArrayWriter();
            this.pw = new PrintWriter(this.caw);
        }
        return this.pw;
    }

    static class ByteArrayServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public void write(int n) {
            this.baos.write(n);
        }

        public void resetByteArray() {
            this.baos.reset();
        }

        public byte[] toByteArray() {
            return this.baos.toByteArray();
        }

        public String toString() {
            return this.baos.toString();
        }

        public String toString(String enc) {
            String result = null;
            try {
                result = this.baos.toString(enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return result;
        }
    }
}

