/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ViewHandlerResponseWrapper;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.jstl.core.Config;

public class ViewHandlerImpl
extends ViewHandler {
    private static Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.application");
    private static final String AFTER_VIEW_CONTENT = "com.sun.faces.AFTER_VIEW_CONTENT";
    private int bufSize = -1;

    public ViewHandlerImpl() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created ViewHandler instance ");
        }
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        if (!viewToRender.isRendered()) {
            return;
        }
        ExternalContext extContext = context.getExternalContext();
        ServletRequest request = (ServletRequest)extContext.getRequest();
        ServletResponse response = (ServletResponse)extContext.getResponse();
        try {
            if (this.executePageToBuildView(context, viewToRender)) {
                response.flushBuffer();
                ApplicationAssociate.getInstance(extContext).responseRendered();
                return;
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Completed building view for : \n" + viewToRender.getViewId());
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "+=+=+=+=+=+= Printout for " + viewToRender.getViewId() + " about to render.");
            DebugUtil.printTree((UIComponent)viewToRender, logger, Level.FINEST);
        }
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(context, viewToRender.getRenderKitId());
        ResponseWriter oldWriter = context.getResponseWriter();
        this.initBuffSize(context);
        WriteBehindStringWriter strWriter = new WriteBehindStringWriter(context, this.bufSize);
        ResponseWriter newWriter = null != oldWriter ? oldWriter.cloneWithWriter((Writer)strWriter) : renderKit.createResponseWriter((Writer)strWriter, null, request.getCharacterEncoding());
        context.setResponseWriter(newWriter);
        newWriter.startDocument();
        this.doRenderView(context, viewToRender);
        newWriter.endDocument();
        ResponseWriter responseWriter = null != oldWriter ? oldWriter.cloneWithWriter((Writer)response.getWriter()) : newWriter.cloneWithWriter((Writer)response.getWriter());
        context.setResponseWriter(responseWriter);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Size of response for view '" + viewToRender + "':" + strWriter.length());
        }
        strWriter.flushToWriter((Writer)responseWriter);
        if (null != oldWriter) {
            context.setResponseWriter(oldWriter);
        }
        this.writeAfterViewContent(extContext, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBuffSize(FacesContext context) {
        if (this.bufSize == -1) {
            ViewHandlerImpl viewHandlerImpl = this;
            synchronized (viewHandlerImpl) {
                if (this.bufSize == -1) {
                    WebConfiguration webConfig = WebConfiguration.getInstance(context.getExternalContext());
                    try {
                        this.bufSize = Integer.parseInt(webConfig.getContextInitParameter(WebConfiguration.WebContextInitParameter.ResponseBufferSize));
                    }
                    catch (NumberFormatException nfe) {
                        this.bufSize = Integer.parseInt(WebConfiguration.WebContextInitParameter.ResponseBufferSize.getDefaultValue());
                    }
                }
            }
        }
    }

    private void doRenderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        ExternalContext extContext = context.getExternalContext();
        ApplicationAssociate associate = ApplicationAssociate.getInstance(extContext);
        if (null != associate) {
            associate.responseRendered();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "About to render view " + viewToRender.getViewId());
        }
        viewToRender.encodeAll(context);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        String renderKitId = this.getRenderkitId(context);
        UIViewRoot viewRoot = Util.getStateManager(context).restoreView(context, viewId, renderKitId);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "+=+=+=+=+=+= Restored View Printout for " + viewId);
            DebugUtil.printTree((UIComponent)viewRoot, logger, Level.FINEST);
        }
        return viewRoot;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        Locale locale = null;
        String renderKitId = null;
        if (context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            renderKitId = context.getViewRoot().getRenderKitId();
        }
        UIViewRoot result = (UIViewRoot)context.getApplication().createComponent("javax.faces.ViewRoot");
        result.setViewId(viewId);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created new view for " + viewId);
        }
        if (locale == null) {
            locale = context.getApplication().getViewHandler().calculateLocale(context);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Locale for this view as determined by calculateLocale " + locale.toString());
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using locale from previous view " + locale.toString());
        }
        if (renderKitId == null) {
            renderKitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("RenderKitId for this view as determined by calculateRenderKitId " + renderKitId);
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using renderKitId from previous view " + renderKitId);
        }
        result.setLocale(locale);
        result.setRenderKitId(renderKitId);
        return result;
    }

    private boolean executePageToBuildView(FacesContext context, UIViewRoot viewToExecute) throws IOException {
        ExternalContext extContext;
        String requestURI;
        if (null == context) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        if (null == viewToExecute) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "viewToExecute");
            throw new NullPointerException(message);
        }
        String mapping = Util.getFacesMapping(context);
        if (mapping.equals(requestURI = this.updateRequestURI(viewToExecute.getViewId(), mapping))) {
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            response.sendError(404);
            return true;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("About to execute view " + requestURI);
        }
        if ((extContext = context.getExternalContext()).getRequest() instanceof ServletRequest) {
            Config.set((ServletRequest)((ServletRequest)extContext.getRequest()), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)context.getViewRoot().getLocale());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Before dispacthMessage to newViewId " + viewToExecute.getViewId());
        }
        Object originalResponse = extContext.getResponse();
        ViewHandlerResponseWrapper wrapped = new ViewHandlerResponseWrapper((HttpServletResponse)extContext.getResponse());
        extContext.setResponse((Object)wrapped);
        extContext.dispatch(requestURI);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("After dispacthMessage to newViewId " + viewToExecute.getViewId());
        }
        extContext.setResponse(originalResponse);
        if (wrapped.getStatus() < 200 || wrapped.getStatus() > 299) {
            wrapped.flushContentToWrappedResponse();
            return true;
        }
        if (wrapped.isBytes()) {
            extContext.getRequestMap().put(AFTER_VIEW_CONTENT, wrapped.getBytes());
        } else if (wrapped.isChars()) {
            extContext.getRequestMap().put(AFTER_VIEW_CONTENT, wrapped.getChars());
        }
        return false;
    }

    public Locale calculateLocale(FacesContext context) {
        Locale perf;
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        Locale result = null;
        Iterator locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext() && (result = this.findMatch(context, perf = (Locale)locales.next())) == null) {
        }
        if (result == null) {
            result = context.getApplication().getDefaultLocale() == null ? Locale.getDefault() : context.getApplication().getDefaultLocale();
        }
        return result;
    }

    public String calculateRenderKitId(FacesContext context) {
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        Map requestParamMap = context.getExternalContext().getRequestParameterMap();
        String result = (String)requestParamMap.get("javax.faces.RenderKitId");
        if (result == null && null == (result = context.getApplication().getDefaultRenderKitId())) {
            result = "HTML_BASIC";
        }
        return result;
    }

    protected Locale findMatch(FacesContext context, Locale pref) {
        Locale defaultLocale;
        Locale result = null;
        Iterator it = context.getApplication().getSupportedLocales();
        while (it.hasNext()) {
            Locale supportedLocale = (Locale)it.next();
            if (pref.equals(supportedLocale)) {
                result = supportedLocale;
                break;
            }
            if (!pref.getLanguage().equals(supportedLocale.getLanguage()) || !supportedLocale.getCountry().equals("")) continue;
            result = supportedLocale;
        }
        if (null == result && (defaultLocale = context.getApplication().getDefaultLocale()) != null) {
            if (pref.equals(defaultLocale)) {
                result = defaultLocale;
            } else if (pref.getLanguage().equals(defaultLocale.getLanguage()) && defaultLocale.getCountry().equals("")) {
                result = defaultLocale;
            }
        }
        return result;
    }

    public void writeState(FacesContext context) throws IOException {
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Begin writing marker for viewId " + context.getViewRoot().getViewId());
        }
        context.getResponseWriter().writeText((Object)"~com.sun.faces.saveStateFieldMarker~", null);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("End writing marker for viewId " + context.getViewRoot().getViewId());
        }
    }

    public String getActionURL(FacesContext context, String viewId) {
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        if (viewId == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "viewId");
            throw new NullPointerException(message);
        }
        if (viewId.charAt(0) != '/') {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_VIEW_ID", viewId);
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "jsf.illegal_view_id_error", viewId);
            }
            throw new IllegalArgumentException(message);
        }
        String contextPath = context.getExternalContext().getRequestContextPath();
        String mapping = Util.getFacesMapping(context);
        if (mapping == null) {
            return contextPath + viewId;
        }
        if (Util.isPrefixMapped(mapping)) {
            if (mapping.equals("/*")) {
                return contextPath + viewId;
            }
            return contextPath + mapping + viewId;
        }
        int period = viewId.lastIndexOf(".");
        if (period < 0) {
            return contextPath + viewId + mapping;
        }
        if (!viewId.endsWith(mapping)) {
            return contextPath + viewId.substring(0, period) + mapping;
        }
        return contextPath + viewId;
    }

    public String getResourceURL(FacesContext context, String path) {
        if (path.startsWith("/")) {
            return context.getExternalContext().getRequestContextPath() + path;
        }
        return path;
    }

    private String updateRequestURI(String uri, String mapping) {
        if (!Util.isPrefixMapped(mapping)) {
            return uri;
        }
        int length = mapping.length() + 1;
        StringBuilder builder = new StringBuilder(length);
        builder.append(mapping).append('/');
        String mappingMod = builder.toString();
        boolean logged = false;
        while (uri.startsWith(mappingMod)) {
            if (!logged && logger.isLoggable(Level.WARNING)) {
                logged = true;
                logger.log(Level.WARNING, "jsf.viewhandler.requestpath.recursion", new Object[]{uri, mapping});
            }
            uri = uri.substring(length - 1);
        }
        return uri;
    }

    private String getRenderkitId(FacesContext context) {
        return context.getApplication().getViewHandler().calculateRenderKitId(context);
    }

    private void writeAfterViewContent(ExternalContext extContext, ServletResponse response) throws IOException {
        Object content = extContext.getRequestMap().get(AFTER_VIEW_CONTENT);
        assert (null != content);
        if (content instanceof char[]) {
            response.getWriter().write((char[])content);
        } else if (content instanceof byte[]) {
            response.getWriter().write(new String((byte[])content));
        } else assert (false);
        response.flushBuffer();
        extContext.getRequestMap().remove(AFTER_VIEW_CONTENT);
    }

    private static final class WriteBehindStringWriter
    extends FastStringWriter {
        private static final int STATE_MARKER_LEN = "~com.sun.faces.saveStateFieldMarker~".length();
        private final FacesContext context;
        private final char[] buf;
        private final int bufSize;

        public WriteBehindStringWriter(FacesContext context, int initialCapcity) {
            super(initialCapcity);
            this.context = context;
            this.bufSize = initialCapcity;
            this.buf = new char[this.bufSize];
        }

        public void flushToWriter(Writer writer) throws IOException {
            StateManager stateManager = Util.getStateManager(this.context);
            Object stateToWrite = stateManager.saveView(this.context);
            int totalLen = this.builder.length();
            int pos = 0;
            int tildeIdx = this.getNextDelimiterIndex(pos);
            while (pos < totalLen) {
                int len;
                if (tildeIdx != -1) {
                    if (tildeIdx > pos && tildeIdx - pos > this.bufSize) {
                        this.builder.getChars(pos, pos + this.bufSize, this.buf, 0);
                        writer.write(this.buf);
                        pos += this.bufSize;
                        continue;
                    }
                    this.builder.getChars(pos, tildeIdx, this.buf, 0);
                    len = tildeIdx - pos;
                    writer.write(this.buf, 0, len);
                    if (this.builder.indexOf("~com.sun.faces.saveStateFieldMarker~", pos) == tildeIdx) {
                        stateManager.writeState(this.context, stateToWrite);
                    }
                    tildeIdx = this.getNextDelimiterIndex(pos += len + STATE_MARKER_LEN);
                    continue;
                }
                if (totalLen - pos > this.bufSize) {
                    this.builder.getChars(pos, pos + this.bufSize, this.buf, 0);
                    writer.write(this.buf);
                    pos += this.bufSize;
                    continue;
                }
                this.builder.getChars(pos, totalLen, this.buf, 0);
                len = totalLen - pos;
                writer.write(this.buf, 0, len);
                pos += len + 1;
            }
        }

        public int length() {
            return this.builder.length();
        }

        private int getNextDelimiterIndex(int offset) {
            return this.builder.indexOf("~", offset);
        }
    }
}

