/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

class ShapeEvaluator {
    private Shape savedv0;
    private Shape savedv1;
    private Geometry geom0;
    private Geometry geom1;

    ShapeEvaluator() {
    }

    public Shape evaluate(Shape shape, Shape shape2, float f) {
        if (this.savedv0 != shape || this.savedv1 != shape2) {
            if (this.savedv0 == shape2 && this.savedv1 == shape) {
                Geometry geometry = this.geom0;
                this.geom0 = this.geom1;
                this.geom1 = geometry;
            } else {
                this.recalculate(shape, shape2);
            }
            this.savedv0 = shape;
            this.savedv1 = shape2;
        }
        return this.getShape(f);
    }

    private void recalculate(Shape shape, Shape shape2) {
        this.geom0 = new Geometry(shape);
        this.geom1 = new Geometry(shape2);
        double[] dArray = this.geom0.getTvals();
        double[] dArray2 = this.geom1.getTvals();
        double[] dArray3 = ShapeEvaluator.mergeTvals(dArray, dArray2);
        this.geom0.setTvals(dArray3);
        this.geom1.setTvals(dArray3);
    }

    private Shape getShape(float f) {
        return new MorphedShape(this.geom0, this.geom1, f);
    }

    private static double[] mergeTvals(double[] dArray, double[] dArray2) {
        int n = ShapeEvaluator.sortTvals(dArray, dArray2, null);
        double[] dArray3 = new double[n];
        ShapeEvaluator.sortTvals(dArray, dArray2, dArray3);
        return dArray3;
    }

    private static int sortTvals(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < dArray.length && n2 < dArray2.length) {
            double d = dArray[n];
            double d2 = dArray2[n2];
            if (d <= d2) {
                if (dArray3 != null) {
                    dArray3[n3] = d;
                }
                ++n;
            }
            if (d2 <= d) {
                if (dArray3 != null) {
                    dArray3[n3] = d2;
                }
                ++n2;
            }
            ++n3;
        }
        return n3;
    }

    private static double interp(double d, double d2, double d3) {
        return d + (d2 - d) * d3;
    }

    private static class Geometry {
        static final double THIRD = 0.3333333333333333;
        static final double MIN_LEN = 0.001;
        double[] bezierCoords = new double[20];
        int numCoords;
        int windingrule;
        double[] myTvals;

        public Geometry(Shape shape) {
            int n;
            int n2;
            double d;
            double d2;
            double d3;
            double d4;
            PathIterator pathIterator = shape.getPathIterator(null);
            this.windingrule = pathIterator.getWindingRule();
            if (pathIterator.isDone()) {
                this.numCoords = 8;
            }
            double[] dArray = new double[6];
            int n3 = pathIterator.currentSegment(dArray);
            pathIterator.next();
            if (n3 != 0) {
                throw new IllegalPathStateException("missing initial moveto");
            }
            double d5 = d4 = dArray[0];
            this.bezierCoords[0] = d4;
            double d6 = d3 = dArray[1];
            this.bezierCoords[1] = d3;
            Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
            this.numCoords = 2;
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(dArray)) {
                    case 0: {
                        if (d5 != d4 || d6 != d3) {
                            this.appendLineTo(d5, d6, d4, d3);
                            d5 = d4;
                            d6 = d3;
                        }
                        d2 = dArray[0];
                        d = dArray[1];
                        if (d5 == d2 && d6 == d) break;
                        vector.add(new Point2D.Double(d4, d3));
                        this.appendLineTo(d5, d6, d2, d);
                        d5 = d4 = d2;
                        d6 = d3 = d;
                        break;
                    }
                    case 4: {
                        if (d5 == d4 && d6 == d3) break;
                        this.appendLineTo(d5, d6, d4, d3);
                        d5 = d4;
                        d6 = d3;
                        break;
                    }
                    case 1: {
                        d2 = dArray[0];
                        d = dArray[1];
                        this.appendLineTo(d5, d6, d2, d);
                        d5 = d2;
                        d6 = d;
                        break;
                    }
                    case 2: {
                        double d7 = dArray[0];
                        double d8 = dArray[1];
                        d2 = dArray[2];
                        d = dArray[3];
                        this.appendQuadTo(d5, d6, d7, d8, d2, d);
                        d5 = d2;
                        d6 = d;
                        break;
                    }
                    case 3: {
                        d5 = dArray[4];
                        d6 = dArray[5];
                        this.appendCubicTo(dArray[0], dArray[1], dArray[2], dArray[3], d5, d6);
                    }
                }
                pathIterator.next();
            }
            if (this.numCoords < 8 || d5 != d4 || d6 != d3) {
                this.appendLineTo(d5, d6, d4, d3);
                d5 = d4;
                d6 = d3;
            }
            for (n2 = vector.size() - 1; n2 >= 0; --n2) {
                Point2D point2D = (Point2D)vector.get(n2);
                d2 = point2D.getX();
                d = point2D.getY();
                if (d5 == d2 && d6 == d) continue;
                this.appendLineTo(d5, d6, d2, d);
                d5 = d2;
                d6 = d;
            }
            n2 = 0;
            double d9 = this.bezierCoords[0];
            double d10 = this.bezierCoords[1];
            for (int i = 6; i < this.numCoords; i += 6) {
                double d11 = this.bezierCoords[i];
                double d12 = this.bezierCoords[i + 1];
                if (!(d12 < d10) && (d12 != d10 || !(d11 < d9))) continue;
                n2 = i;
                d9 = d11;
                d10 = d12;
            }
            if (n2 > 0) {
                double[] dArray2 = new double[this.numCoords];
                System.arraycopy(this.bezierCoords, n2, dArray2, 0, this.numCoords - n2);
                System.arraycopy(this.bezierCoords, 2, dArray2, this.numCoords - n2, n2);
                this.bezierCoords = dArray2;
            }
            double d13 = 0.0;
            d5 = this.bezierCoords[0];
            d6 = this.bezierCoords[1];
            for (n = 2; n < this.numCoords; n += 2) {
                d2 = this.bezierCoords[n];
                d = this.bezierCoords[n + 1];
                d13 += d5 * d - d2 * d6;
                d5 = d2;
                d6 = d;
            }
            if (d13 < 0.0) {
                n = 2;
                for (int i = this.numCoords - 4; n < i; n += 2, i -= 2) {
                    d5 = this.bezierCoords[n];
                    d6 = this.bezierCoords[n + 1];
                    this.bezierCoords[n] = this.bezierCoords[i];
                    this.bezierCoords[n + 1] = this.bezierCoords[i + 1];
                    this.bezierCoords[i] = d5;
                    this.bezierCoords[i + 1] = d6;
                }
            }
        }

        private void appendLineTo(double d, double d2, double d3, double d4) {
            this.appendCubicTo(ShapeEvaluator.interp(d, d3, 0.3333333333333333), ShapeEvaluator.interp(d2, d4, 0.3333333333333333), ShapeEvaluator.interp(d3, d, 0.3333333333333333), ShapeEvaluator.interp(d4, d2, 0.3333333333333333), d3, d4);
        }

        private void appendQuadTo(double d, double d2, double d3, double d4, double d5, double d6) {
            this.appendCubicTo(ShapeEvaluator.interp(d3, d, 0.3333333333333333), ShapeEvaluator.interp(d4, d2, 0.3333333333333333), ShapeEvaluator.interp(d3, d5, 0.3333333333333333), ShapeEvaluator.interp(d4, d6, 0.3333333333333333), d5, d6);
        }

        private void appendCubicTo(double d, double d2, double d3, double d4, double d5, double d6) {
            if (this.numCoords + 6 > this.bezierCoords.length) {
                int n = (this.numCoords - 2) * 2 + 2;
                double[] dArray = new double[n];
                System.arraycopy(this.bezierCoords, 0, dArray, 0, this.numCoords);
                this.bezierCoords = dArray;
            }
            this.bezierCoords[this.numCoords++] = d;
            this.bezierCoords[this.numCoords++] = d2;
            this.bezierCoords[this.numCoords++] = d3;
            this.bezierCoords[this.numCoords++] = d4;
            this.bezierCoords[this.numCoords++] = d5;
            this.bezierCoords[this.numCoords++] = d6;
        }

        public int getWindingRule() {
            return this.windingrule;
        }

        public int getNumCoords() {
            return this.numCoords;
        }

        public double getCoord(int n) {
            return this.bezierCoords[n];
        }

        public double[] getTvals() {
            double d;
            double d2;
            if (this.myTvals != null) {
                return this.myTvals;
            }
            double[] dArray = new double[(this.numCoords - 2) / 6 + 1];
            double d3 = this.bezierCoords[0];
            double d4 = this.bezierCoords[1];
            double d5 = 0.0;
            int n = 2;
            int n2 = 0;
            while (n < this.numCoords) {
                d2 = d3;
                d = d4;
                double d6 = this.bezierCoords[n++];
                double d7 = this.bezierCoords[n++];
                double d8 = Math.sqrt((d2 -= d6) * d2 + (d -= d7) * d);
                d2 = d6;
                d = d7;
                d6 = this.bezierCoords[n++];
                d7 = this.bezierCoords[n++];
                d8 += Math.sqrt((d2 -= d6) * d2 + (d -= d7) * d);
                d2 = d6;
                d = d7;
                d6 = this.bezierCoords[n++];
                d7 = this.bezierCoords[n++];
                d8 += Math.sqrt((d2 -= d6) * d2 + (d -= d7) * d);
                d8 += Math.sqrt((d3 -= d6) * d3 + (d4 -= d7) * d4);
                if ((d8 /= 2.0) < 0.001) {
                    d8 = 0.001;
                }
                dArray[n2++] = d5 += d8;
                d3 = d6;
                d4 = d7;
            }
            d2 = dArray[0];
            dArray[0] = 0.0;
            for (n2 = 1; n2 < dArray.length - 1; ++n2) {
                d = dArray[n2];
                dArray[n2] = d2 / d5;
                d2 = d;
            }
            dArray[n2] = 1.0;
            this.myTvals = dArray;
            return dArray;
        }

        public void setTvals(double[] dArray) {
            double d;
            double d2;
            double[] dArray2 = this.bezierCoords;
            double[] dArray3 = new double[2 + (dArray.length - 1) * 6];
            double[] dArray4 = this.getTvals();
            int n = 0;
            double d3 = d2 = dArray2[n++];
            double d4 = d2;
            double d5 = d2;
            double d6 = d = dArray2[n++];
            double d7 = d;
            double d8 = d;
            int n2 = 0;
            dArray3[n2++] = d5;
            dArray3[n2++] = d8;
            double d9 = 0.0;
            double d10 = 0.0;
            int n3 = 1;
            int n4 = 1;
            while (n4 < dArray.length) {
                if (d9 >= d10) {
                    d5 = d2;
                    d8 = d;
                    d4 = dArray2[n++];
                    d7 = dArray2[n++];
                    d3 = dArray2[n++];
                    d6 = dArray2[n++];
                    d2 = dArray2[n++];
                    d = dArray2[n++];
                    d10 = dArray4[n3++];
                }
                int n5 = n4++;
                double d11 = dArray[n5];
                if (d11 < d10) {
                    double d12 = (d11 - d9) / (d10 - d9);
                    dArray3[n2++] = d5 = ShapeEvaluator.interp(d5, d4, d12);
                    dArray3[n2++] = d8 = ShapeEvaluator.interp(d8, d7, d12);
                    d4 = ShapeEvaluator.interp(d4, d3, d12);
                    d7 = ShapeEvaluator.interp(d7, d6, d12);
                    d3 = ShapeEvaluator.interp(d3, d2, d12);
                    d6 = ShapeEvaluator.interp(d6, d, d12);
                    dArray3[n2++] = d5 = ShapeEvaluator.interp(d5, d4, d12);
                    dArray3[n2++] = d8 = ShapeEvaluator.interp(d8, d7, d12);
                    d4 = ShapeEvaluator.interp(d4, d3, d12);
                    d7 = ShapeEvaluator.interp(d7, d6, d12);
                    dArray3[n2++] = d5 = ShapeEvaluator.interp(d5, d4, d12);
                    dArray3[n2++] = d8 = ShapeEvaluator.interp(d8, d7, d12);
                } else {
                    dArray3[n2++] = d4;
                    dArray3[n2++] = d7;
                    dArray3[n2++] = d3;
                    dArray3[n2++] = d6;
                    dArray3[n2++] = d2;
                    dArray3[n2++] = d;
                }
                d9 = d11;
            }
            this.bezierCoords = dArray3;
            this.numCoords = dArray3.length;
            this.myTvals = dArray;
        }
    }

    private static class Iterator
    implements PathIterator {
        AffineTransform at;
        Geometry g0;
        Geometry g1;
        double t;
        int cindex;

        public Iterator(AffineTransform affineTransform, Geometry geometry, Geometry geometry2, double d) {
            this.at = affineTransform;
            this.g0 = geometry;
            this.g1 = geometry2;
            this.t = d;
        }

        public int getWindingRule() {
            return this.t < 0.5 ? this.g0.getWindingRule() : this.g1.getWindingRule();
        }

        public boolean isDone() {
            return this.cindex > this.g0.getNumCoords();
        }

        public void next() {
            this.cindex = this.cindex == 0 ? 2 : (this.cindex += 6);
        }

        public int currentSegment(float[] fArray) {
            return this.currentSegment(fArray, null);
        }

        public int currentSegment(double[] dArray) {
            return this.currentSegment(null, dArray);
        }

        private int currentSegment(float[] fArray, double[] dArray) {
            int n;
            int n2;
            if (this.cindex == 0) {
                n2 = 0;
                n = 2;
            } else if (this.cindex >= this.g0.getNumCoords()) {
                n2 = 4;
                n = 0;
            } else {
                n2 = 3;
                n = 6;
            }
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    double d = ShapeEvaluator.interp(this.g0.getCoord(this.cindex + i), this.g1.getCoord(this.cindex + i), this.t);
                    if (fArray != null) {
                        fArray[i] = (float)d;
                        continue;
                    }
                    dArray[i] = d;
                }
                if (this.at != null) {
                    if (fArray != null) {
                        this.at.transform(fArray, 0, fArray, 0, n / 2);
                    } else {
                        this.at.transform(dArray, 0, dArray, 0, n / 2);
                    }
                }
            }
            return n2;
        }
    }

    private static class MorphedShape
    implements Shape {
        Geometry geom0;
        Geometry geom1;
        double t;
        private Shape compatShape;

        MorphedShape(Geometry geometry, Geometry geometry2, double d) {
            this.geom0 = geometry;
            this.geom1 = geometry2;
            this.t = d;
        }

        public Rectangle getBounds() {
            return this.getBounds2D().getBounds();
        }

        public Rectangle2D getBounds2D() {
            double d;
            double d2;
            int n = this.geom0.getNumCoords();
            double d3 = d2 = ShapeEvaluator.interp(this.geom0.getCoord(0), this.geom1.getCoord(0), this.t);
            double d4 = d = ShapeEvaluator.interp(this.geom0.getCoord(1), this.geom1.getCoord(1), this.t);
            for (int i = 2; i < n; i += 2) {
                double d5 = ShapeEvaluator.interp(this.geom0.getCoord(i), this.geom1.getCoord(i), this.t);
                double d6 = ShapeEvaluator.interp(this.geom0.getCoord(i + 1), this.geom1.getCoord(i + 1), this.t);
                if (d3 > d5) {
                    d3 = d5;
                }
                if (d4 > d6) {
                    d4 = d6;
                }
                if (d2 < d5) {
                    d2 = d5;
                }
                if (!(d < d6)) continue;
                d = d6;
            }
            return new Rectangle2D.Double(d3, d4, d2 - d3, d - d4);
        }

        public boolean contains(double d, double d2) {
            if (this.compatShape == null) {
                this.compatShape = new GeneralPath(this);
            }
            return this.compatShape.contains(d, d2);
        }

        public boolean contains(Point2D point2D) {
            return this.contains(point2D.getX(), point2D.getY());
        }

        public boolean intersects(double d, double d2, double d3, double d4) {
            if (this.compatShape == null) {
                this.compatShape = new GeneralPath(this);
            }
            return this.compatShape.intersects(d, d2, d3, d4);
        }

        public boolean intersects(Rectangle2D rectangle2D) {
            return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }

        public boolean contains(double d, double d2, double d3, double d4) {
            if (this.compatShape == null) {
                this.compatShape = new GeneralPath(this);
            }
            return this.compatShape.contains(d, d2, d3, d4);
        }

        public boolean contains(Rectangle2D rectangle2D) {
            return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }

        public PathIterator getPathIterator(AffineTransform affineTransform) {
            return new Iterator(affineTransform, this.geom0, this.geom1, this.t);
        }

        public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
            return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
        }
    }
}

