/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.GroupBoundsHelper;
import com.sun.javafx.sg.PGGroup;
import com.sun.javafx.sg.PGNode;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.j2d.J2DFilterContext;
import com.sun.scenario.scenegraph.NodeEffectInput;
import com.sun.scenario.scenegraph.SGNode;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGGroup
extends SGNode
implements PGGroup {
    private static AffineTransform IDENTITY = new AffineTransform();
    private static AffineTransform TEMP_TX = new AffineTransform();
    private static Point2D TEMP_PT = new Point2D();
    private GroupBoundsHelper helper;
    private ArrayList<PGNode> children = new ArrayList(1);
    private List<PGNode> immutable = Collections.unmodifiableList(this.children);
    private Blend.Mode blendMode = Blend.Mode.SRC_OVER;
    private boolean childDirty = true;

    private void manageHelper() {
        if (this.helper == null && this.children.size() > 1) {
            this.helper = new GroupBoundsHelper((PGGroup)this);
        }
    }

    public void add(int n, PGNode pGNode) {
        if (n < -1 || n > this.children.size()) {
            throw new IndexOutOfBoundsException("invalid index");
        }
        SGNode sGNode = (SGNode)pGNode;
        SGGroup sGGroup = sGNode.getParent();
        if (sGGroup != null && sGGroup != this) {
            throw new IllegalArgumentException("Cannot add a child that already has a parent");
        }
        SGNode sGNode2 = sGNode.getClipParent();
        if (sGNode2 != null) {
            throw new IllegalArgumentException("Cannot add a child to a group that is a clip node too");
        }
        if (sGGroup == this) {
            this.children.remove(pGNode);
            if (n == -1) {
                this.children.add(pGNode);
            } else {
                this.children.add(n, pGNode);
            }
            sGNode.visualsChanged(true);
        } else {
            if (n == -1) {
                this.children.add(pGNode);
            } else {
                this.children.add(n, pGNode);
            }
            sGNode.setParent((Object)this);
            this.manageHelper();
            if (this.helper != null) {
                boolean bl = this.helper.childAdded(pGNode);
                if (bl) {
                    this.contentBoundsChanged(true);
                } else {
                    sGNode.visualsChanged(true);
                }
            } else {
                this.contentBoundsChanged(true);
            }
        }
    }

    public List<PGNode> getContent() {
        return this.immutable;
    }

    public void remove(PGNode pGNode) {
        if (pGNode != null) {
            SGNode sGNode = (SGNode)pGNode;
            sGNode.setParent(null);
            this.children.remove(pGNode);
        }
        if (this.helper != null) {
            boolean bl = this.helper.childRemoved(pGNode);
            if (bl) {
                this.contentBoundsChanged(true);
            } else {
                this.visualsChanged(true);
            }
        } else {
            this.contentBoundsChanged(true);
        }
    }

    public void remove(int n) {
        if (n >= 0 && n < this.children.size()) {
            this.remove(this.children.get(n));
        }
    }

    public void clear() {
        for (PGNode pGNode : this.children) {
            SGNode sGNode = (SGNode)pGNode;
            sGNode.setParent(null);
            if (this.helper == null) continue;
            this.helper.childRemoved(pGNode);
        }
        this.children.clear();
        this.contentBoundsChanged(true);
        this.visualsChanged(true);
    }

    public void setBlendMode(Object object) {
        this.setBlendMode((Blend.Mode)object);
    }

    @Override
    public boolean computeIntersects(float f, float f2, float f3, float f4) {
        for (int i = 0; i < this.children.size(); ++i) {
            PGNode pGNode = this.children.get(i);
            if (!pGNode.intersects(f, f2, f3, f4)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean computeContains(float f, float f2) {
        if (this.children.size() == 0) {
            return false;
        }
        if (super.computeContains(f, f2)) {
            for (int i = 0; i < this.children.size(); ++i) {
                SGGroup.TEMP_PT.x = f;
                SGGroup.TEMP_PT.y = f2;
                SGNode sGNode = (SGNode)this.children.get(i);
                sGNode.parentToLocal(TEMP_PT);
                if (!sGNode.contains(SGGroup.TEMP_PT.x, SGGroup.TEMP_PT.y)) continue;
                return true;
            }
        }
        return false;
    }

    public void setBlendMode(Blend.Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode must be non-null");
        }
        if (this.blendMode != mode) {
            this.blendMode = mode;
            this.visualsChanged(true);
        }
    }

    @Override
    public SGNode lookup(String string) {
        SGNode sGNode = super.lookup(string);
        if (sGNode != null) {
            return sGNode;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            SGNode sGNode2 = (SGNode)this.children.get(i);
            sGNode = sGNode2.lookup(string);
            if (sGNode == null) continue;
            return sGNode;
        }
        return null;
    }

    @Override
    public Bounds2D computeBounds(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (this.helper == null) {
            if (this.children.size() == 1 && this.children.get(0).isVisible()) {
                return this.children.get(0).getCompleteBounds(bounds2D, baseTransform);
            }
            return bounds2D.makeEmpty();
        }
        return this.helper.getContentBounds(bounds2D, baseTransform);
    }

    protected final Bounds2D computeDirtyRegion(Bounds2D bounds2D, Bounds2D bounds2D2, BaseTransform baseTransform) {
        SGNode sGNode;
        if (this.children.size() == 0 && !this.dirty) {
            return bounds2D2.makeEmpty();
        }
        if (this.dirty || this.filters != null && this.filters.effectFilter != null) {
            return super.computeDirtyRegion(bounds2D, bounds2D2, baseTransform);
        }
        this.updateTxBounds();
        if (!this.lastTxBounds.isInvalid() && !this.lastTxBounds.equals((Object)this.cachedTxBounds)) {
            return super.computeDirtyRegion(bounds2D, bounds2D2, baseTransform);
        }
        double d = baseTransform.getMxx();
        double d2 = baseTransform.getMyx();
        double d3 = baseTransform.getMxy();
        double d4 = baseTransform.getMyy();
        double d5 = baseTransform.getMxt();
        double d6 = baseTransform.getMyt();
        BaseTransform baseTransform2 = baseTransform;
        if (this.tx != null) {
            baseTransform2 = baseTransform2.deriveWithConcatenation(this.tx);
        }
        int n = this.children.size();
        for (int i = 0; i < n && ((sGNode = (SGNode)this.children.get(i)).isClean() || (bounds2D2 = sGNode.accumulateDirtyRegions(bounds2D, bounds2D2, baseTransform)) != null); ++i) {
        }
        if (baseTransform2 == baseTransform) {
            baseTransform.restoreTransform(d, d2, d3, d4, d5, d6);
        }
        return bounds2D2;
    }

    protected final void clearDirty() {
        this.childDirty = false;
        super.clearDirty();
    }

    @Override
    protected final boolean cull(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (this.cullIfNoChildren() && this.children.size() == 0) {
            return true;
        }
        return super.cull(bounds2D, baseTransform);
    }

    boolean cullIfNoChildren() {
        return true;
    }

    @Override
    void renderContent(Graphics2D graphics2D, Bounds2D bounds2D, BaseTransform baseTransform) {
        if (this.blendMode == Blend.Mode.SRC_OVER) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                SGNode sGNode = (SGNode)this.children.get(i);
                sGNode.render(graphics2D, bounds2D, baseTransform);
            }
        } else {
            Blend blend = new Blend(this.blendMode, null, null);
            GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
            J2DFilterContext j2DFilterContext = J2DFilterContext.getInstance((GraphicsConfiguration)graphicsConfiguration);
            ImageData imageData = null;
            boolean bl = true;
            do {
                Object object;
                if (imageData != null) {
                    imageData.unref();
                    imageData = null;
                }
                for (int i = 0; i < this.children.size(); ++i) {
                    object = (SGNode)this.children.get(i);
                    ImageData imageData2 = NodeEffectInput.getImageDataForNode((FilterContext)j2DFilterContext, object, false, baseTransform);
                    if (imageData == null) {
                        imageData = imageData2;
                        continue;
                    }
                    ImageData imageData3 = blend.filterImageDatas((FilterContext)j2DFilterContext, baseTransform, new ImageData[]{imageData, imageData2});
                    imageData.unref();
                    imageData2.unref();
                    imageData = imageData3;
                }
                if (imageData == null || !(bl = imageData.validate((FilterContext)j2DFilterContext))) continue;
                graphics2D.setTransform(IDENTITY);
                Rectangle rectangle = imageData.getBounds();
                object = (Image)imageData.getImage().getData();
                graphics2D.drawImage((Image)object, rectangle.x, rectangle.y, null);
                graphics2D.setTransform(SGGroup.toAWTTransform(baseTransform, TEMP_TX));
            } while (imageData == null || !bl);
            if (imageData != null) {
                imageData.unref();
            }
        }
    }

    @Override
    boolean hasOverlappingContents() {
        if (this.blendMode != Blend.Mode.SRC_OVER) {
            return false;
        }
        int n = this.children.size();
        if (n == 1) {
            return ((SGNode)this.children.get(0)).hasOverlappingContents();
        }
        return n != 0;
    }

    public void childBoundsInvisible(SGNode sGNode) {
        sGNode.visualsChanged(true);
        this.childBoundsChanged();
        if (this.helper != null) {
            this.helper.childRemoved((PGNode)sGNode);
        }
    }

    public void childBoundsChanged() {
        if (this.helper != null) {
            this.helper.invalidate();
        }
        this.childDirty = true;
        this.contentBoundsChanged(false);
    }

    public void childVisualsChanged() {
        this.childDirty = true;
        this.visualsChanged(false);
    }

    public final boolean isClean() {
        return !this.childDirty && super.isClean();
    }
}

