/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.javafx.sg.PGShape;
import com.sun.scenario.paint.ProportionalPaint;
import com.sun.scenario.scenegraph.SGLeaf;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class SGAbstractShape
extends SGLeaf
implements PGShape {
    private static final Stroke defaultStroke = new BasicStroke(1.0f);
    PGShape.Mode mode = PGShape.Mode.FILL;
    Paint drawPaint = Color.BLACK;
    Paint fillPaint = Color.BLACK;
    Stroke drawStroke = defaultStroke;
    Paint validDrawPaint;
    Paint validFillPaint;
    public static final double CtrlVal = 0.5522847498307933;

    protected abstract Paint getRelativePaint(ProportionalPaint var1);

    protected void geomChanged(boolean bl) {
        this.validFillPaint = null;
        this.validDrawPaint = null;
        this.contentBoundsChanged(true);
    }

    protected void strokeChanged() {
        this.contentBoundsChanged(true);
    }

    public abstract Shape getShape();

    public final PGShape.Mode getMode() {
        return this.mode;
    }

    public void setMode(PGShape.Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("null mode");
        }
        if (this.mode != mode) {
            this.mode = mode;
            this.contentBoundsChanged(true);
        }
    }

    public final Paint getDrawPaint() {
        if (this.validDrawPaint == null) {
            this.validDrawPaint = this.drawPaint instanceof ProportionalPaint ? this.getRelativePaint((ProportionalPaint)this.drawPaint) : this.drawPaint;
        }
        return this.validDrawPaint;
    }

    public void setDrawPaint(Paint paint) {
        this.drawPaint = paint;
        this.validDrawPaint = null;
        this.visualsChanged(true);
    }

    public final Paint getFillPaint() {
        if (this.validFillPaint == null) {
            this.validFillPaint = this.fillPaint instanceof ProportionalPaint ? this.getRelativePaint((ProportionalPaint)this.fillPaint) : this.fillPaint;
        }
        return this.validFillPaint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
        this.validFillPaint = null;
        this.visualsChanged(true);
    }

    public final Stroke getDrawStroke() {
        return this.drawStroke;
    }

    public void setDrawStroke(Stroke stroke) {
        if (this.drawStroke != stroke) {
            if (stroke == null) {
                throw new IllegalArgumentException("null drawStroke");
            }
            this.drawStroke = stroke;
            this.strokeChanged();
        }
    }

    public boolean computeContains(float f, float f2) {
        Shape shape = this.getShape();
        if (shape != null) {
            return shape.contains(f, f2);
        }
        return super.computeContains(f, f2);
    }

    public boolean computeIntersects(float f, float f2, float f3, float f4) {
        Shape shape = this.getShape();
        if (shape != null) {
            return shape.intersects(f, f2, f3, f4);
        }
        return super.intersects(f, f2, f3, f4);
    }

    boolean hasOverlappingContents() {
        return this.getMode() == PGShape.Mode.STROKE_FILL;
    }

    public void setAntialiased(boolean bl) {
    }

    public void setDrawPaint(Object object) {
        this.setDrawPaint((Paint)object);
    }

    public void setFillPaint(Object object) {
        this.setFillPaint((Paint)object);
    }

    public void setDrawStroke(float f, PGShape.StrokeType strokeType, PGShape.StrokeLineCap strokeLineCap, PGShape.StrokeLineJoin strokeLineJoin, float f2, float[] fArray, float f3) {
        int n = strokeLineCap == PGShape.StrokeLineCap.BUTT ? 0 : (strokeLineCap == PGShape.StrokeLineCap.SQUARE ? 2 : 1);
        int n2 = strokeLineJoin == PGShape.StrokeLineJoin.BEVEL ? 2 : (strokeLineJoin == PGShape.StrokeLineJoin.MITER ? 0 : 1);
        if (strokeType != PGShape.StrokeType.CENTERED) {
            f *= 2.0f;
        }
        BasicStroke basicStroke = fArray.length > 0 ? new BasicStroke(f, n, n2, f2, fArray, f3) : new BasicStroke(f, n, n2, f2);
        Stroke stroke = strokeType == PGShape.StrokeType.INSIDE ? new InnerStroke(basicStroke) : (strokeType == PGShape.StrokeType.OUTSIDE ? new OuterStroke(basicStroke) : basicStroke);
        this.setDrawStroke(stroke);
    }

    public static Point2D cornerArc(GeneralPath generalPath, float f, float f2, float f3, float f4, float f5, float f6) {
        return SGAbstractShape.cornerArc(generalPath, f, f2, f3, f4, f5, f6, 0.5f);
    }

    public static Point2D cornerArc(GeneralPath generalPath, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = (float)((double)f + 0.5522847498307933 * (double)(f3 - f));
        float f9 = (float)((double)f2 + 0.5522847498307933 * (double)(f4 - f2));
        float f10 = (float)((double)f5 + 0.5522847498307933 * (double)(f3 - f5));
        float f11 = (float)((double)f6 + 0.5522847498307933 * (double)(f4 - f6));
        generalPath.curveTo(f8, f9, f10, f11, f5, f6);
        return new Point2D.Float(SGAbstractShape.eval(f, f8, f10, f5, f7), SGAbstractShape.eval(f2, f9, f11, f6, f7));
    }

    public static float eval(float f, float f2, float f3, float f4, float f5) {
        f += (f2 - f) * f5;
        f2 += (f3 - f2) * f5;
        f3 += (f4 - f3) * f5;
        f += (f2 - f) * f5;
        f2 += (f3 - f2) * f5;
        return f + (f2 - f) * f5;
    }

    public static class InnerStroke
    implements Stroke {
        BasicStroke stroke;

        public InnerStroke(BasicStroke basicStroke) {
            this.stroke = basicStroke;
        }

        public BasicStroke getBasicStroke() {
            return this.stroke;
        }

        public Shape createInnerStrokedRect(Rectangle2D rectangle2D) {
            if (this.stroke.getDashArray() != null) {
                return null;
            }
            float f = this.stroke.getLineWidth() / 2.0f;
            if ((double)f >= rectangle2D.getWidth() || (double)f >= rectangle2D.getHeight()) {
                return rectangle2D;
            }
            float f2 = (float)rectangle2D.getX();
            float f3 = (float)rectangle2D.getY();
            float f4 = f2 + (float)rectangle2D.getWidth();
            float f5 = f3 + (float)rectangle2D.getHeight();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f2, f3);
            generalPath.lineTo(f4, f3);
            generalPath.lineTo(f4, f5);
            generalPath.lineTo(f2, f5);
            generalPath.closePath();
            generalPath.moveTo(f2 += f, f3 += f);
            generalPath.lineTo(f2, f5 -= f);
            generalPath.lineTo(f4 -= f, f5);
            generalPath.lineTo(f4, f3);
            generalPath.closePath();
            return generalPath;
        }

        public Shape createInnerStrokedEllipse(Ellipse2D ellipse2D) {
            float f;
            if (this.stroke.getDashArray() != null) {
                return null;
            }
            float f2 = this.stroke.getLineWidth() / 2.0f;
            float f3 = (float)ellipse2D.getWidth();
            if (f3 - 2.0f * f2 > (f = (float)ellipse2D.getHeight()) * 2.0f || f - 2.0f * f2 > f3 * 2.0f) {
                return null;
            }
            if (f2 >= f3 || f2 >= f) {
                return ellipse2D;
            }
            float f4 = (float)ellipse2D.getX();
            float f5 = (float)ellipse2D.getY();
            float f6 = f4 + f3 / 2.0f;
            float f7 = f5 + f / 2.0f;
            float f8 = f4 + f3;
            float f9 = f5 + f;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f6, f5);
            SGAbstractShape.cornerArc(generalPath, f6, f5, f8, f5, f8, f7);
            SGAbstractShape.cornerArc(generalPath, f8, f7, f8, f9, f6, f9);
            SGAbstractShape.cornerArc(generalPath, f6, f9, f4, f9, f4, f7);
            SGAbstractShape.cornerArc(generalPath, f4, f7, f4, f5, f6, f5);
            generalPath.closePath();
            f8 -= f2;
            generalPath.moveTo(f6, f5 += f2);
            SGAbstractShape.cornerArc(generalPath, f6, f5, f4 += f2, f5, f4, f7);
            SGAbstractShape.cornerArc(generalPath, f4, f7, f4, f9 -= f2, f6, f9);
            SGAbstractShape.cornerArc(generalPath, f6, f9, f8, f9, f8, f7);
            SGAbstractShape.cornerArc(generalPath, f8, f7, f8, f5, f6, f5);
            generalPath.closePath();
            return generalPath;
        }

        public Shape createStrokedShape(Shape shape) {
            Shape shape2;
            if (shape instanceof Rectangle2D && (shape2 = this.createInnerStrokedRect((Rectangle2D)shape)) != null) {
                return shape2;
            }
            shape2 = new Area(this.stroke.createStrokedShape(shape));
            ((Area)shape2).intersect(new Area(shape));
            return shape2;
        }
    }

    public static class OuterStroke
    implements Stroke {
        static double SQRT_2 = Math.sqrt(2.0);
        BasicStroke stroke;

        public OuterStroke(BasicStroke basicStroke) {
            this.stroke = basicStroke;
        }

        public BasicStroke getBasicStroke() {
            return this.stroke;
        }

        public Shape createOuterStrokedRect(Rectangle2D rectangle2D) {
            if (this.stroke.getDashArray() != null) {
                return null;
            }
            float f = this.stroke.getLineWidth() / 2.0f;
            float f2 = (float)rectangle2D.getX();
            float f3 = (float)rectangle2D.getY();
            float f4 = f2 + (float)rectangle2D.getWidth();
            float f5 = f3 + (float)rectangle2D.getHeight();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f2, f3);
            generalPath.lineTo(f4, f3);
            generalPath.lineTo(f4, f5);
            generalPath.lineTo(f2, f5);
            generalPath.closePath();
            float f6 = f2 - f;
            float f7 = f3 - f;
            float f8 = f4 + f;
            float f9 = f5 + f;
            switch (this.stroke.getLineJoin()) {
                case 0: {
                    if ((double)this.stroke.getMiterLimit() >= SQRT_2) {
                        generalPath.moveTo(f6, f7);
                        generalPath.lineTo(f6, f9);
                        generalPath.lineTo(f8, f9);
                        generalPath.lineTo(f8, f7);
                        generalPath.closePath();
                        break;
                    }
                }
                case 2: {
                    generalPath.moveTo(f6, f3);
                    generalPath.lineTo(f6, f5);
                    generalPath.lineTo(f2, f9);
                    generalPath.lineTo(f4, f9);
                    generalPath.lineTo(f8, f5);
                    generalPath.lineTo(f8, f3);
                    generalPath.lineTo(f4, f7);
                    generalPath.lineTo(f2, f7);
                    generalPath.closePath();
                    break;
                }
                case 1: {
                    generalPath.moveTo(f6, f3);
                    generalPath.lineTo(f6, f5);
                    SGAbstractShape.cornerArc(generalPath, f6, f5, f6, f9, f2, f9);
                    generalPath.lineTo(f4, f9);
                    SGAbstractShape.cornerArc(generalPath, f4, f9, f8, f9, f8, f5);
                    generalPath.lineTo(f8, f3);
                    SGAbstractShape.cornerArc(generalPath, f8, f3, f8, f7, f4, f7);
                    generalPath.lineTo(f2, f7);
                    SGAbstractShape.cornerArc(generalPath, f2, f7, f6, f7, f6, f3);
                    generalPath.closePath();
                    break;
                }
                default: {
                    throw new InternalError("Unrecognized line join style");
                }
            }
            return generalPath;
        }

        public Shape createOuterStrokedEllipse(Ellipse2D ellipse2D) {
            float f;
            if (this.stroke.getDashArray() != null) {
                return null;
            }
            float f2 = this.stroke.getLineWidth() / 2.0f;
            float f3 = (float)ellipse2D.getWidth();
            if (f3 > (f = (float)ellipse2D.getHeight()) * 2.0f || f > f3 * 2.0f) {
                return null;
            }
            float f4 = (float)ellipse2D.getX();
            float f5 = (float)ellipse2D.getY();
            float f6 = f4 + f3 / 2.0f;
            float f7 = f5 + f / 2.0f;
            float f8 = f4 + f3;
            float f9 = f5 + f;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f6, f5);
            SGAbstractShape.cornerArc(generalPath, f6, f5, f8, f5, f8, f7);
            SGAbstractShape.cornerArc(generalPath, f8, f7, f8, f9, f6, f9);
            SGAbstractShape.cornerArc(generalPath, f6, f9, f4, f9, f4, f7);
            SGAbstractShape.cornerArc(generalPath, f4, f7, f4, f5, f6, f5);
            generalPath.closePath();
            f8 += f2;
            generalPath.moveTo(f6, f5 -= f2);
            SGAbstractShape.cornerArc(generalPath, f6, f5, f4 -= f2, f5, f4, f7);
            SGAbstractShape.cornerArc(generalPath, f4, f7, f4, f9 += f2, f6, f9);
            SGAbstractShape.cornerArc(generalPath, f6, f9, f8, f9, f8, f7);
            SGAbstractShape.cornerArc(generalPath, f8, f7, f8, f5, f6, f5);
            generalPath.closePath();
            return generalPath;
        }

        public Shape createStrokedShape(Shape shape) {
            Shape shape2;
            if (shape instanceof Rectangle2D && (shape2 = this.createOuterStrokedRect((Rectangle2D)shape)) != null) {
                return shape2;
            }
            shape2 = new Area(this.stroke.createStrokedShape(shape));
            ((Area)shape2).subtract(new Area(shape));
            return shape2;
        }
    }
}

