/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.impl.j2d.J2DEffectHelper;
import com.sun.scenario.scenegraph.NodeEffectInput;
import com.sun.scenario.scenegraph.SGNode;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;

class EffectFilter {
    private Effect effect;
    private NodeEffectInput nodeInput;
    private EffectListener listener;

    EffectFilter(Effect effect, SGNode sGNode) {
        this.effect = effect;
        this.nodeInput = new NodeEffectInput(sGNode);
        this.listener = new EffectListener(sGNode);
        effect.addPropertyChangeListener((PropertyChangeListener)this.listener);
    }

    void render(Graphics2D graphics2D, Bounds2D bounds2D, BaseTransform baseTransform) {
        J2DEffectHelper.render((Effect)this.effect, (Graphics2D)graphics2D, (float)0.0f, (float)0.0f, (Effect)this.nodeInput);
        this.nodeInput.flush();
    }

    Bounds2D getBounds(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (bounds2D == null) {
            bounds2D = new Bounds2D();
        }
        bounds2D.setBounds(this.effect.getBounds(baseTransform, (Effect)this.nodeInput));
        return bounds2D;
    }

    void dispose() {
        this.effect.removePropertyChangeListener((PropertyChangeListener)this.listener);
        this.effect = null;
        this.nodeInput.setNode(null);
        this.nodeInput = null;
        this.listener = null;
    }

    private static class EffectListener
    implements PropertyChangeListener {
        private WeakReference<SGNode> ref = null;

        EffectListener(SGNode sGNode) {
            this.ref = new WeakReference<SGNode>(sGNode);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SGNode sGNode = (SGNode)((Object)this.ref.get());
            if (sGNode != null) {
                sGNode.invalidateCache();
                sGNode.completeBoundsChanged(true);
            }
        }
    }
}

