/*
 * Decompiled with CFR 0.152.
 */
package com.sun.embeddedswing;

import com.sun.embeddedswing.EmbeddedPeer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

class EmbeddedRepaintManager
extends RepaintManager {
    private RepaintManager delegate;
    private static final Rectangle NULL_RECTANGLE = new Rectangle();
    private static final Dimension NULL_DIMENSION = new Dimension();

    public EmbeddedRepaintManager(RepaintManager repaintManager) {
        this.delegate = repaintManager;
    }

    void setDelegate(RepaintManager repaintManager) {
        this.delegate = repaintManager;
    }

    public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        EmbeddedPeer.Shell shell = (EmbeddedPeer.Shell)SwingUtilities.getAncestorOfClass(EmbeddedPeer.Shell.class, jComponent);
        if (shell != null) {
            Point point = SwingUtilities.convertPoint(jComponent, new Point(n, n2), shell);
            shell.repaint(point.x, point.y, n3, n4);
        } else if (this.delegate != null) {
            this.delegate.addDirtyRegion(jComponent, n, n2, n3, n4);
        }
    }

    public void addInvalidComponent(JComponent jComponent) {
        if (this.delegate == null || SwingUtilities.getAncestorOfClass(EmbeddedPeer.Shell.class, jComponent) != null) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.addInvalidComponent(jComponent);
        }
    }

    public Rectangle getDirtyRegion(JComponent jComponent) {
        if (this.delegate != null && SwingUtilities.getAncestorOfClass(EmbeddedPeer.Shell.class, jComponent) == null) {
            return this.delegate.getDirtyRegion(jComponent);
        }
        return NULL_RECTANGLE;
    }

    public Dimension getDoubleBufferMaximumSize() {
        if (this.delegate != null) {
            return this.delegate.getDoubleBufferMaximumSize();
        }
        return NULL_DIMENSION;
    }

    public Image getOffscreenBuffer(Component component, int n, int n2) {
        if (this.delegate != null && SwingUtilities.getAncestorOfClass(EmbeddedPeer.Shell.class, component) == null) {
            return this.delegate.getOffscreenBuffer(component, n, n2);
        }
        return null;
    }

    public Image getVolatileOffscreenBuffer(Component component, int n, int n2) {
        if (this.delegate != null && SwingUtilities.getAncestorOfClass(EmbeddedPeer.Shell.class, component) == null) {
            return this.delegate.getVolatileOffscreenBuffer(component, n, n2);
        }
        return null;
    }

    public boolean isCompletelyDirty(JComponent jComponent) {
        if (this.delegate != null && SwingUtilities.getAncestorOfClass(EmbeddedPeer.Shell.class, jComponent) == null) {
            return this.delegate.isCompletelyDirty(jComponent);
        }
        return false;
    }

    public boolean isDoubleBufferingEnabled() {
        if (this.delegate != null) {
            return this.delegate.isDoubleBufferingEnabled();
        }
        return false;
    }

    public void markCompletelyClean(JComponent jComponent) {
        if (this.delegate != null && SwingUtilities.getAncestorOfClass(EmbeddedPeer.Shell.class, jComponent) == null) {
            this.delegate.markCompletelyClean(jComponent);
        }
    }

    public void markCompletelyDirty(JComponent jComponent) {
        EmbeddedPeer.Shell shell = (EmbeddedPeer.Shell)SwingUtilities.getAncestorOfClass(EmbeddedPeer.Shell.class, jComponent);
        if (shell != null) {
            Point point = SwingUtilities.convertPoint(jComponent, new Point(0, 0), shell);
            shell.repaint(point.x, point.y, jComponent.getWidth(), jComponent.getHeight());
            return;
        }
        if (this.delegate != null) {
            this.delegate.markCompletelyDirty(jComponent);
        }
    }

    public void paintDirtyRegions() {
        if (this.delegate != null) {
            this.delegate.paintDirtyRegions();
        }
    }

    public void removeInvalidComponent(JComponent jComponent) {
        if (this.delegate != null && SwingUtilities.getAncestorOfClass(EmbeddedPeer.Shell.class, jComponent) == null) {
            this.delegate.removeInvalidComponent(jComponent);
        }
    }

    public void setDoubleBufferingEnabled(boolean bl) {
        if (this.delegate != null) {
            this.delegate.setDoubleBufferingEnabled(bl);
        }
    }

    public void setDoubleBufferMaximumSize(Dimension dimension) {
        if (this.delegate != null) {
            this.delegate.setDoubleBufferMaximumSize(dimension);
        }
    }

    public void validateInvalidComponents() {
        if (this.delegate != null) {
            this.delegate.validateInvalidComponents();
        }
    }
}

