/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Crossings;
import com.sun.javafx.geom.Curve;

final class Order1
extends Curve {
    private float x0;
    private float y0;
    private float x1;
    private float y1;
    private float xmin;
    private float xmax;

    public Order1(float f, float f2, float f3, float f4, int n) {
        super(n);
        this.x0 = f;
        this.y0 = f2;
        this.x1 = f3;
        this.y1 = f4;
        if (f < f3) {
            this.xmin = f;
            this.xmax = f3;
        } else {
            this.xmin = f3;
            this.xmax = f;
        }
    }

    public int getOrder() {
        return 1;
    }

    public float getXTop() {
        return this.x0;
    }

    public float getYTop() {
        return this.y0;
    }

    public float getXBot() {
        return this.x1;
    }

    public float getYBot() {
        return this.y1;
    }

    public float getXMin() {
        return this.xmin;
    }

    public float getXMax() {
        return this.xmax;
    }

    public float getX0() {
        return this.direction == 1 ? this.x0 : this.x1;
    }

    public float getY0() {
        return this.direction == 1 ? this.y0 : this.y1;
    }

    public float getX1() {
        return this.direction == -1 ? this.x0 : this.x1;
    }

    public float getY1() {
        return this.direction == -1 ? this.y0 : this.y1;
    }

    public float XforY(float f) {
        if (this.x0 == this.x1 || f <= this.y0) {
            return this.x0;
        }
        if (f >= this.y1) {
            return this.x1;
        }
        return this.x0 + (f - this.y0) * (this.x1 - this.x0) / (this.y1 - this.y0);
    }

    public float TforY(float f) {
        if (f <= this.y0) {
            return 0.0f;
        }
        if (f >= this.y1) {
            return 1.0f;
        }
        return (f - this.y0) / (this.y1 - this.y0);
    }

    public float XforT(float f) {
        return this.x0 + f * (this.x1 - this.x0);
    }

    public float YforT(float f) {
        return this.y0 + f * (this.y1 - this.y0);
    }

    public float dXforT(float f, int n) {
        switch (n) {
            case 0: {
                return this.x0 + f * (this.x1 - this.x0);
            }
            case 1: {
                return this.x1 - this.x0;
            }
        }
        return 0.0f;
    }

    public float dYforT(float f, int n) {
        switch (n) {
            case 0: {
                return this.y0 + f * (this.y1 - this.y0);
            }
            case 1: {
                return this.y1 - this.y0;
            }
        }
        return 0.0f;
    }

    public float nextVertical(float f, float f2) {
        return f2;
    }

    public boolean accumulateCrossings(Crossings crossings) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5 = crossings.getXLo();
        float f6 = crossings.getYLo();
        float f7 = crossings.getXHi();
        float f8 = crossings.getYHi();
        if (this.xmin >= f7) {
            return false;
        }
        if (this.y0 < f6) {
            if (this.y1 <= f6) {
                return false;
            }
            f4 = f6;
            f3 = this.XforY(f6);
        } else {
            if (this.y0 >= f8) {
                return false;
            }
            f4 = this.y0;
            f3 = this.x0;
        }
        if (this.y1 > f8) {
            f2 = f8;
            f = this.XforY(f8);
        } else {
            f2 = this.y1;
            f = this.x1;
        }
        if (f3 >= f7 && f >= f7) {
            return false;
        }
        if (f3 > f5 || f > f5) {
            return true;
        }
        crossings.record(f4, f2, this.direction);
        return false;
    }

    public void enlarge(Bounds2D bounds2D) {
        bounds2D.add(this.x0, this.y0);
        bounds2D.add(this.x1, this.y1);
    }

    public Curve getSubCurve(float f, float f2, int n) {
        if (f == this.y0 && f2 == this.y1) {
            return this.getWithDirection(n);
        }
        if (this.x0 == this.x1) {
            return new Order1(this.x0, f, this.x1, f2, n);
        }
        float f3 = this.x0 - this.x1;
        float f4 = this.y0 - this.y1;
        float f5 = this.x0 + (f - this.y0) * f3 / f4;
        float f6 = this.x0 + (f2 - this.y0) * f3 / f4;
        return new Order1(f5, f, f6, f2, n);
    }

    public Curve getReversedCurve() {
        return new Order1(this.x0, this.y0, this.x1, this.y1, -this.direction);
    }

    public int compareTo(Curve curve, float[] fArray) {
        float f;
        if (!(curve instanceof Order1)) {
            return super.compareTo(curve, fArray);
        }
        Order1 order1 = (Order1)curve;
        if (fArray[1] <= fArray[0]) {
            throw new InternalError("yrange already screwed up...");
        }
        fArray[1] = Math.min(Math.min(fArray[1], this.y1), order1.y1);
        if (fArray[1] <= fArray[0]) {
            throw new InternalError("backstepping from " + fArray[0] + " to " + fArray[1]);
        }
        if (this.xmax <= order1.xmin) {
            return this.xmin == order1.xmax ? 0 : -1;
        }
        if (this.xmin >= order1.xmax) {
            return 1;
        }
        float f2 = order1.x1 - order1.x0;
        float f3 = this.y1 - this.y0;
        float f4 = this.x1 - this.x0;
        float f5 = order1.y1 - order1.y0;
        float f6 = f2 * f3 - f4 * f5;
        if (f6 != 0.0f) {
            float f7 = (this.x0 - order1.x0) * f3 * f5 - this.y0 * f4 * f5 + order1.y0 * f2 * f3;
            f = f7 / f6;
            if (f <= fArray[0]) {
                f = Math.min(this.y1, order1.y1);
            } else {
                if (f < fArray[1]) {
                    fArray[1] = f;
                }
                f = Math.max(this.y0, order1.y0);
            }
        } else {
            f = Math.max(this.y0, order1.y0);
        }
        return Order1.orderof(this.XforY(f), order1.XforY(f));
    }

    public int getSegment(float[] fArray) {
        if (this.direction == 1) {
            fArray[0] = this.x1;
            fArray[1] = this.y1;
        } else {
            fArray[0] = this.x0;
            fArray[1] = this.y0;
        }
        return 1;
    }
}

