/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Curve;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Crossings {
    public static final boolean debug = false;
    int limit = 0;
    float[] yranges = new float[10];
    float xlo;
    float ylo;
    float xhi;
    float yhi;

    public Crossings(float f, float f2, float f3, float f4) {
        this.xlo = f;
        this.ylo = f2;
        this.xhi = f3;
        this.yhi = f4;
    }

    public final float getXLo() {
        return this.xlo;
    }

    public final float getYLo() {
        return this.ylo;
    }

    public final float getXHi() {
        return this.xhi;
    }

    public final float getYHi() {
        return this.yhi;
    }

    public abstract void record(float var1, float var2, int var3);

    public void print() {
        System.out.println("Crossings [");
        System.out.println("  bounds = [" + this.ylo + ", " + this.yhi + "]");
        for (int i = 0; i < this.limit; i += 2) {
            System.out.println("  [" + this.yranges[i] + ", " + this.yranges[i + 1] + "]");
        }
        System.out.println("]");
    }

    public final boolean isEmpty() {
        return this.limit == 0;
    }

    public abstract boolean covers(float var1, float var2);

    public static Crossings findCrossings(Vector vector, float f, float f2, float f3, float f4) {
        EvenOdd evenOdd = new EvenOdd(f, f2, f3, f4);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            if (!curve.accumulateCrossings(evenOdd)) continue;
            return null;
        }
        return evenOdd;
    }

    public static final class EvenOdd
    extends Crossings {
        public EvenOdd(float f, float f2, float f3, float f4) {
            super(f, f2, f3, f4);
        }

        public final boolean covers(float f, float f2) {
            return this.limit == 2 && this.yranges[0] <= f && this.yranges[1] >= f2;
        }

        public void record(float f, float f2, int n) {
            int n2;
            if (f >= f2) {
                return;
            }
            for (n2 = 0; n2 < this.limit && f > this.yranges[n2 + 1]; n2 += 2) {
            }
            int n3 = n2;
            while (n2 < this.limit) {
                float f3;
                float f4;
                float f5;
                float f6;
                float f7 = this.yranges[n2++];
                float f8 = this.yranges[n2++];
                if (f2 < f7) {
                    this.yranges[n3++] = f;
                    this.yranges[n3++] = f2;
                    f = f7;
                    f2 = f8;
                    continue;
                }
                if (f < f7) {
                    f6 = f;
                    f5 = f7;
                } else {
                    f6 = f7;
                    f5 = f;
                }
                if (f2 < f8) {
                    f4 = f2;
                    f3 = f8;
                } else {
                    f4 = f8;
                    f3 = f2;
                }
                if (f5 == f4) {
                    f = f6;
                    f2 = f3;
                } else {
                    if (f5 > f4) {
                        f = f4;
                        f4 = f5;
                        f5 = f;
                    }
                    if (f6 != f5) {
                        this.yranges[n3++] = f6;
                        this.yranges[n3++] = f5;
                    }
                    f = f4;
                    f2 = f3;
                }
                if (!(f >= f2)) continue;
                break;
            }
            if (n3 < n2 && n2 < this.limit) {
                System.arraycopy(this.yranges, n2, this.yranges, n3, this.limit - n2);
            }
            n3 += this.limit - n2;
            if (f < f2) {
                if (n3 >= this.yranges.length) {
                    float[] fArray = new float[n3 + 10];
                    System.arraycopy(this.yranges, 0, fArray, 0, n3);
                    this.yranges = fArray;
                }
                this.yranges[n3++] = f;
                this.yranges[n3++] = f2;
            }
            this.limit = n3;
        }
    }
}

