/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.ShapePair;
import com.sun.javafx.geom.transform.BaseTransform;

public final class ConcentricShapePair
extends ShapePair {
    private final Shape outer;
    private final Shape inner;

    public ConcentricShapePair(Shape shape, Shape shape2) {
        this.outer = shape;
        this.inner = shape2;
    }

    public int getCombinationType() {
        return 1;
    }

    public Shape getOuterShape() {
        return this.outer;
    }

    public Shape getInnerShape() {
        return this.inner;
    }

    public Shape copy() {
        return new ConcentricShapePair(this.outer.copy(), this.inner.copy());
    }

    public boolean contains(float f, float f2) {
        return this.outer.contains(f, f2) && !this.inner.contains(f, f2);
    }

    public boolean intersects(float f, float f2, float f3, float f4) {
        return this.outer.intersects(f, f2, f3, f4) && !this.inner.contains(f, f2, f3, f4);
    }

    public boolean contains(float f, float f2, float f3, float f4) {
        return this.outer.contains(f, f2, f3, f4) && !this.inner.intersects(f, f2, f3, f4);
    }

    public Bounds2D getBounds2D() {
        return this.outer.getBounds2D();
    }

    public PathIterator getPathIterator(BaseTransform baseTransform) {
        return new PairIterator(this.outer.getPathIterator(baseTransform), this.inner.getPathIterator(baseTransform));
    }

    public PathIterator getPathIterator(BaseTransform baseTransform, float f) {
        return new PairIterator(this.outer.getPathIterator(baseTransform, f), this.inner.getPathIterator(baseTransform, f));
    }

    static class PairIterator
    implements PathIterator {
        PathIterator outer;
        PathIterator inner;

        PairIterator(PathIterator pathIterator, PathIterator pathIterator2) {
            this.outer = pathIterator;
            this.inner = pathIterator2;
        }

        public int getWindingRule() {
            return 0;
        }

        public int currentSegment(float[] fArray) {
            if (this.outer.isDone()) {
                return this.inner.currentSegment(fArray);
            }
            return this.outer.currentSegment(fArray);
        }

        public boolean isDone() {
            return this.outer.isDone() && this.inner.isDone();
        }

        public void next() {
            if (this.outer.isDone()) {
                this.inner.next();
            } else {
                this.outer.next();
            }
        }
    }
}

