/*
 * Decompiled with CFR 0.152.
 */
package it.dex.movingimageviewlib.evaluating.evaluators;

import android.view.View;
import android.view.ViewTreeObserver;
import it.dex.movingimageviewlib.evaluating.Evaluator;

public class ScrollEvaluator
extends Evaluator
implements ViewTreeObserver.OnScrollChangedListener {
    private int[] viewLocation = new int[2];

    public ScrollEvaluator(View view) {
        super(view);
    }

    public ScrollEvaluator(View view, Evaluator.OnEventOccurred onEventOccurred) {
        super(view, onEventOccurred);
    }

    @Override
    public void onCreate(View view) {
        view.getViewTreeObserver().addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
    }

    @Override
    public float evaluateX(View view) {
        return this.viewLocation[0];
    }

    @Override
    public float evaluateY(View view) {
        return this.viewLocation[1];
    }

    @Override
    public void onDestroy(View view) {
        view.getViewTreeObserver().removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
    }

    public void onScrollChanged() {
        this.getView().getLocationInWindow(this.viewLocation);
        if (this.viewLocation[0] + this.getView().getWidth() / 2 == this.getView().getContext().getResources().getDisplayMetrics().widthPixels / 2 && this.viewLocation[1] + this.getView().getHeight() / 2 == this.getView().getContext().getResources().getDisplayMetrics().heightPixels / 2 && this.getOnEventOccurred() != null && this.isNotifyEvent()) {
            this.getOnEventOccurred().onEventOccurred(this.getView(), this, Evaluator.EVENT_STATUS.MIDDLE, ++this.middleLoopCount);
        }
        this.getView().invalidate();
    }
}

