/*
 * Decompiled with CFR 0.152.
 */
package ir.smartdevelopers.smartspinner;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;
import ir.smartdevelopers.smartspinner.R;
import ir.smartdevelopers.smartspinner.SmartSpinnerBackgroundDrawable;

public class SmartSpinner
extends AppCompatTextView {
    private SmartSpinnerBackgroundDrawable spinnerBackground;
    private int mDirection = 0;
    private int mTint = 0;
    private int mLineColor = 0;
    private int mArrowColor = 0;
    private int mDeactivateColor = 0;
    private int mArrowSize = -1;
    private boolean mRoundArrow;
    private int mStyle = 0;

    public SmartSpinner(Context context) {
        super(context);
        this.init(context, null);
    }

    public SmartSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SmartSpinner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.spinnerBackground = new SmartSpinnerBackgroundDrawable(context);
        boolean roundArrow = false;
        if (attributeSet != null) {
            int[] set = new int[]{16843698};
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, set);
            this.mDirection = typedArray.getInt(0, 0);
            typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SmartSpinner);
            this.mLineColor = typedArray.getColor(R.styleable.SmartSpinner_lineColor, 0);
            this.mArrowColor = typedArray.getColor(R.styleable.SmartSpinner_arrowColor, 0);
            this.mDeactivateColor = typedArray.getColor(R.styleable.SmartSpinner_deactivateColor, 0);
            this.mTint = typedArray.getColor(R.styleable.SmartSpinner_tint, 0);
            this.mArrowSize = typedArray.getDimensionPixelSize(R.styleable.SmartSpinner_arrowSize, -1);
            roundArrow = typedArray.getBoolean(R.styleable.SmartSpinner_roundArrow, false);
            boolean enabled = typedArray.getBoolean(R.styleable.SmartSpinner_android_enabled, true);
            this.setEnabled(enabled);
            this.mStyle = typedArray.getInt(R.styleable.SmartSpinner_spStyle, 0);
            typedArray.recycle();
        }
        this.spinnerBackground.setDirection(this.mDirection);
        this.spinnerBackground.setLineColor(this.mLineColor);
        this.spinnerBackground.setArrowColor(this.mArrowColor);
        this.spinnerBackground.setDeactivateColor(this.mDeactivateColor);
        this.spinnerBackground.setStyle(this.mStyle);
        if (this.mTint != 0) {
            this.spinnerBackground.setTint(this.mTint);
        }
        if (this.mArrowSize != -1) {
            this.spinnerBackground.setArrowSize(this.mArrowSize);
        }
        this.spinnerBackground.setRoundArrow(roundArrow);
        this.setBackground(this.spinnerBackground);
        this.setClickable(true);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public int getTint() {
        return this.mTint;
    }

    public void setTint(int tint) {
        this.mTint = tint;
        this.spinnerBackground.mutate();
        this.spinnerBackground.setTint(this.mTint);
        this.postInvalidate();
    }

    public int getLineColor() {
        return this.mLineColor;
    }

    public void setLineColor(int lineColor) {
        this.mLineColor = lineColor;
        this.spinnerBackground.setLineColor(this.mLineColor);
        this.postInvalidate();
    }

    public int getArrowColor() {
        return this.mArrowColor;
    }

    public void setArrowColor(int arrowColor) {
        this.mArrowColor = arrowColor;
        this.spinnerBackground.setArrowColor(this.mArrowColor);
        this.postInvalidate();
    }

    public boolean isRoundArrow() {
        return this.mRoundArrow;
    }

    public void setRoundArrow(boolean roundArrow) {
        this.mRoundArrow = roundArrow;
        this.spinnerBackground.setRoundArrow(this.mRoundArrow);
        this.postInvalidate();
    }

    public int getDeactivateColor() {
        return this.mDeactivateColor;
    }

    public void setDeactivateColor(int deactivateColor) {
        this.mDeactivateColor = deactivateColor;
    }
}

