/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.date;

import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.wdullaer.materialdatetimepicker.R;
import com.wdullaer.materialdatetimepicker.Utils;
import com.wdullaer.materialdatetimepicker.date.DatePickerController;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;
import com.wdullaer.materialdatetimepicker.date.DayPickerView;
import com.wdullaer.materialdatetimepicker.date.SimpleDayPickerView;
import com.wdullaer.materialdatetimepicker.date.SimpleMonthView;

public class DayPickerGroup
extends ViewGroup
implements View.OnClickListener,
DayPickerView.OnPageListener {
    private ImageButton prevButton;
    private ImageButton nextButton;
    private DayPickerView dayPickerView;
    private DatePickerController controller;
    private Typeface font;

    public DayPickerGroup(Context context) {
        super(context);
        this.init();
    }

    public DayPickerGroup(Context context, @NonNull DatePickerController controller) {
        super(context);
        this.controller = controller;
        this.init();
    }

    public DayPickerGroup(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DayPickerGroup(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public DayPickerGroup(Context context, @NonNull DatePickerController controller, Typeface font2) {
        super(context);
        this.controller = controller;
        this.font = font2;
        this.init();
    }

    private void init() {
        this.dayPickerView = new SimpleDayPickerView(this.getContext(), this.controller, this.font);
        this.addView((View)this.dayPickerView);
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        ViewGroup content = (ViewGroup)inflater.inflate(R.layout.mdtp_daypicker_group, (ViewGroup)this, false);
        while (content.getChildCount() > 0) {
            View view = content.getChildAt(0);
            content.removeViewAt(0);
            this.addView(view);
        }
        this.prevButton = (ImageButton)this.findViewById(R.id.mdtp_previous_month_arrow);
        this.nextButton = (ImageButton)this.findViewById(R.id.mdtp_next_month_arrow);
        if (this.controller.getVersion() == DatePickerDialog.Version.VERSION_1) {
            int size = Utils.dpToPx(16.0f, this.getResources());
            this.prevButton.setMinimumHeight(size);
            this.prevButton.setMinimumWidth(size);
            this.nextButton.setMinimumHeight(size);
            this.nextButton.setMinimumWidth(size);
        }
        if (this.controller.isThemeDark()) {
            int color2 = ContextCompat.getColor((Context)this.getContext(), (int)R.color.mdtp_date_picker_text_normal_dark_theme);
            this.prevButton.setColorFilter(color2);
            this.nextButton.setColorFilter(color2);
        }
        this.prevButton.setOnClickListener((View.OnClickListener)this);
        this.nextButton.setOnClickListener((View.OnClickListener)this);
        this.dayPickerView.setOnPageListener(this);
    }

    private void updateButtonVisibility(int position) {
        boolean isHorizontal = this.controller.getScrollOrientation() == DatePickerDialog.ScrollOrientation.HORIZONTAL;
        boolean hasPrev = position > 0;
        boolean hasNext = position < this.dayPickerView.getCount() - 1;
        this.prevButton.setVisibility(isHorizontal && hasPrev ? 0 : 4);
        this.nextButton.setVisibility(isHorizontal && hasNext ? 0 : 4);
    }

    public void onChange() {
        this.dayPickerView.onChange();
    }

    public void onDateChanged() {
        this.dayPickerView.onDateChanged();
    }

    public void postSetSelection(int position) {
        this.dayPickerView.postSetSelection(position);
    }

    public int getMostVisiblePosition() {
        return this.dayPickerView.getMostVisiblePosition();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChild((View)this.dayPickerView, widthMeasureSpec, heightMeasureSpec);
        int measuredWidthAndState = this.dayPickerView.getMeasuredWidthAndState();
        int measuredHeightAndState = this.dayPickerView.getMeasuredHeightAndState();
        this.setMeasuredDimension(measuredWidthAndState, measuredHeightAndState);
        int pagerWidth = this.dayPickerView.getMeasuredWidth();
        int pagerHeight = this.dayPickerView.getMeasuredHeight();
        int buttonWidthSpec = View.MeasureSpec.makeMeasureSpec((int)pagerWidth, (int)Integer.MIN_VALUE);
        int buttonHeightSpec = View.MeasureSpec.makeMeasureSpec((int)pagerHeight, (int)Integer.MIN_VALUE);
        this.prevButton.measure(buttonWidthSpec, buttonHeightSpec);
        this.nextButton.measure(buttonWidthSpec, buttonHeightSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        ImageButton rightButton;
        ImageButton leftButton;
        if (ViewCompat.getLayoutDirection((View)this) == 1) {
            leftButton = this.nextButton;
            rightButton = this.prevButton;
        } else {
            leftButton = this.prevButton;
            rightButton = this.nextButton;
        }
        int topMargin = this.controller.getVersion() == DatePickerDialog.Version.VERSION_1 ? 0 : this.getContext().getResources().getDimensionPixelSize(R.dimen.mdtp_date_picker_view_animator_padding_v2);
        int width = right - left;
        int height = bottom - top;
        this.dayPickerView.layout(0, topMargin, width, height);
        SimpleMonthView monthView = (SimpleMonthView)this.dayPickerView.getChildAt(0);
        int monthHeight = monthView.getMonthHeight();
        int cellWidth = monthView.getCellWidth();
        int edgePadding = monthView.getEdgePadding();
        int leftDW = leftButton.getMeasuredWidth();
        int leftDH = leftButton.getMeasuredHeight();
        int leftIconTop = topMargin + monthView.getPaddingTop() + (monthHeight - leftDH) / 2;
        int leftIconLeft = edgePadding + (cellWidth - leftDW) / 2;
        leftButton.layout(leftIconLeft, leftIconTop, leftIconLeft + leftDW, leftIconTop + leftDH);
        int rightDW = rightButton.getMeasuredWidth();
        int rightDH = rightButton.getMeasuredHeight();
        int rightIconTop = topMargin + monthView.getPaddingTop() + (monthHeight - rightDH) / 2;
        int rightIconRight = width - edgePadding - (cellWidth - rightDW) / 2 - 2;
        rightButton.layout(rightIconRight - rightDW, rightIconTop, rightIconRight, rightIconTop + rightDH);
    }

    @Override
    public void onPageChanged(int position) {
        this.updateButtonVisibility(position);
        this.dayPickerView.accessibilityAnnouncePageChanged();
    }

    public void onClick(@NonNull View v) {
        int offset;
        if (this.nextButton == v) {
            offset = 1;
        } else if (this.prevButton == v) {
            offset = -1;
        } else {
            return;
        }
        int position = this.dayPickerView.getMostVisiblePosition() + offset;
        if (position >= 0 && position < this.dayPickerView.getCount()) {
            this.dayPickerView.smoothScrollToPosition(position);
            this.updateButtonVisibility(position);
        }
    }
}

