/*
 * Decompiled with CFR 0.152.
 */
package ir.mstajbakhsh.livehiddencamera.HiddenCameraLayout;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import ir.mstajbakhsh.livehiddencamera.HiddenCameraLayout.CameraConfig;
import ir.mstajbakhsh.livehiddencamera.LiveBroadcaster.SrsCameraView;

public class HiddenCameraLayout {
    Context cntx;
    SrsCameraView cam;
    WindowManager mWindowManager;
    PermissionHandler ph;

    public HiddenCameraLayout(Context cntx, PermissionHandler ph) {
        this.cntx = cntx;
        this.ph = ph;
    }

    public WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    public SrsCameraView initHiddenLayout(CameraConfig config) {
        this.cam = new SrsCameraView(this.getContext());
        this.cam.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mWindowManager = (WindowManager)this.getContext().getSystemService("window");
        int LAYOUT_FLAG = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        WindowManager.LayoutParams params = new WindowManager.LayoutParams(1, 1, LAYOUT_FLAG, 262144, -3);
        try {
            this.mWindowManager.addView((View)this.cam, (ViewGroup.LayoutParams)params);
        }
        catch (Exception ex) {
            this.ph.onPermissionNotGrantedException(ex);
        }
        this.cam.startCameraInternal(config);
        return this.cam;
    }

    private Context getContext() {
        return this.cntx;
    }

    public static interface PermissionHandler {
        public void onPermissionNotGrantedException(Exception var1);
    }
}

