/*
 * Decompiled with CFR 0.152.
 */
package ir.mstajbakhsh.livehiddencamera.HiddenCameraLayout;

import android.content.Context;
import android.support.annotation.NonNull;
import java.io.File;

public class CameraConfig {
    private Context mContext;
    private int mFacing = 0;
    private File mImageFile;

    public Builder getBuilder(Context context) {
        this.mContext = context;
        return new Builder();
    }

    int getFacing() {
        return this.mFacing;
    }

    public class Builder {
        public Builder setCameraFacing(int cameraFacing) {
            if (cameraFacing != 0 && cameraFacing != 1) {
                throw new RuntimeException("Invalid camera facing value.");
            }
            CameraConfig.this.mFacing = cameraFacing;
            return this;
        }

        public Builder setImageFile(File imageFile) {
            CameraConfig.this.mImageFile = imageFile;
            return this;
        }

        public CameraConfig build() {
            if (CameraConfig.this.mImageFile == null) {
                CameraConfig.this.mImageFile = this.getDefaultStorageFile();
            }
            return CameraConfig.this;
        }

        @NonNull
        private File getDefaultStorageFile() {
            return new File("/sdcard/DCIM/test.jpg");
        }
    }
}

