/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4;

import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbstractDescriptorBox
extends AbstractFullBox {
    private static Logger log = Logger.getLogger(AbstractDescriptorBox.class.getName());
    public BaseDescriptor descriptor;
    public ByteBuffer data;

    public AbstractDescriptorBox(String type) {
        super(type);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        this.data.rewind();
        byteBuffer.put(this.data);
    }

    @Override
    protected long getContentSize() {
        return 4 + this.data.limit();
    }

    public BaseDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(BaseDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getDescriptorAsString() {
        return this.descriptor.toString();
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.data = content.slice();
        content.position(content.position() + content.remaining());
        try {
            this.data.rewind();
            this.descriptor = ObjectDescriptorFactory.createFrom(-1, this.data);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error parsing ObjectDescriptor", e);
        }
        catch (IndexOutOfBoundsException e) {
            log.log(Level.WARNING, "Error parsing ObjectDescriptor", e);
        }
    }
}

