/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.apple;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class BaseMediaInfoAtom
extends AbstractFullBox {
    public static final String TYPE = "gmin";
    short graphicsMode = (short)64;
    int opColorR = 32768;
    int opColorG = 32768;
    int opColorB = 32768;
    short balance;
    short reserved;

    public BaseMediaInfoAtom() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 16L;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.putShort(this.graphicsMode);
        IsoTypeWriter.writeUInt16(byteBuffer, this.opColorR);
        IsoTypeWriter.writeUInt16(byteBuffer, this.opColorG);
        IsoTypeWriter.writeUInt16(byteBuffer, this.opColorB);
        byteBuffer.putShort(this.balance);
        byteBuffer.putShort(this.reserved);
    }

    @Override
    protected void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.graphicsMode = content.getShort();
        this.opColorR = IsoTypeReader.readUInt16(content);
        this.opColorG = IsoTypeReader.readUInt16(content);
        this.opColorB = IsoTypeReader.readUInt16(content);
        this.balance = content.getShort();
        this.reserved = content.getShort();
    }

    public short getGraphicsMode() {
        return this.graphicsMode;
    }

    public void setGraphicsMode(short graphicsMode) {
        this.graphicsMode = graphicsMode;
    }

    public int getOpColorR() {
        return this.opColorR;
    }

    public void setOpColorR(int opColorR) {
        this.opColorR = opColorR;
    }

    public int getOpColorG() {
        return this.opColorG;
    }

    public void setOpColorG(int opColorG) {
        this.opColorG = opColorG;
    }

    public int getOpColorB() {
        return this.opColorB;
    }

    public void setOpColorB(int opColorB) {
        this.opColorB = opColorB;
    }

    public short getBalance() {
        return this.balance;
    }

    public void setBalance(short balance) {
        this.balance = balance;
    }

    public short getReserved() {
        return this.reserved;
    }

    public void setReserved(short reserved) {
        this.reserved = reserved;
    }

    public String toString() {
        return "BaseMediaInfoAtom{graphicsMode=" + this.graphicsMode + ", opColorR=" + this.opColorR + ", opColorG=" + this.opColorG + ", opColorB=" + this.opColorB + ", balance=" + this.balance + ", reserved=" + this.reserved + '}';
    }
}

