/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.DataEntryUrlBox;
import com.coremedia.iso.boxes.DataInformationBox;
import com.coremedia.iso.boxes.DataReferenceBox;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.HandlerBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.StaticChunkOffsetBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentRandomAccessBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentRandomAccessOffsetBox;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.ByteBufferHelper;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.authoring.builder.Mp4Builder;
import com.googlecode.mp4parser.authoring.builder.SyncSampleIntersectFinderImpl;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class FragmentedMp4Builder
implements Mp4Builder {
    private static final Logger LOG = Logger.getLogger(FragmentedMp4Builder.class.getName());
    protected FragmentIntersectionFinder intersectionFinder = new SyncSampleIntersectFinderImpl();

    public List<String> getAllowedHandlers() {
        return Arrays.asList("soun", "vide");
    }

    public Box createFtyp(Movie movie) {
        LinkedList<String> minorBrands = new LinkedList<String>();
        minorBrands.add("isom");
        minorBrands.add("iso2");
        minorBrands.add("avc1");
        return new FileTypeBox("isom", 0L, minorBrands);
    }

    protected List<Track> sortTracksInSequence(List<Track> tracks, final int cycle, final Map<Track, long[]> intersectionMap) {
        tracks = new LinkedList<Track>(tracks);
        Collections.sort(tracks, new Comparator<Track>(){

            @Override
            public int compare(Track o1, Track o2) {
                long[] startSamples1 = (long[])intersectionMap.get(o1);
                long startSample1 = startSamples1[cycle];
                long endSample1 = cycle + 1 < startSamples1.length ? startSamples1[cycle + 1] : (long)(o1.getSamples().size() + 1);
                long[] startSamples2 = (long[])intersectionMap.get(o2);
                long startSample2 = startSamples2[cycle];
                long endSample2 = cycle + 1 < startSamples2.length ? startSamples2[cycle + 1] : (long)(o2.getSamples().size() + 1);
                List<ByteBuffer> samples1 = o1.getSamples().subList(CastUtils.l2i(startSample1) - 1, CastUtils.l2i(endSample1) - 1);
                List<ByteBuffer> samples2 = o2.getSamples().subList(CastUtils.l2i(startSample2) - 1, CastUtils.l2i(endSample2) - 1);
                int size1 = 0;
                for (ByteBuffer byteBuffer : samples1) {
                    size1 += byteBuffer.limit();
                }
                int size2 = 0;
                for (ByteBuffer byteBuffer : samples2) {
                    size2 += byteBuffer.limit();
                }
                return size1 - size2;
            }
        });
        return tracks;
    }

    protected List<Box> createMoofMdat(Movie movie) {
        LinkedList<Box> boxes = new LinkedList<Box>();
        HashMap<Track, long[]> intersectionMap = new HashMap<Track, long[]>();
        int maxNumberOfFragments = 0;
        for (Track track : movie.getTracks()) {
            long[] intersects = this.intersectionFinder.sampleNumbers(track, movie);
            intersectionMap.put(track, intersects);
            maxNumberOfFragments = Math.max(maxNumberOfFragments, intersects.length);
        }
        int sequence = 1;
        for (int cycle = 0; cycle < maxNumberOfFragments; ++cycle) {
            List<Track> sortedTracks = this.sortTracksInSequence(movie.getTracks(), cycle, intersectionMap);
            for (Track track : sortedTracks) {
                long endSample;
                long startSample;
                long[] startSamples;
                if (!this.getAllowedHandlers().isEmpty() && !this.getAllowedHandlers().contains(track.getHandler()) || cycle >= (startSamples = intersectionMap.get(track)).length || (startSample = startSamples[cycle]) == (endSample = cycle + 1 < startSamples.length ? startSamples[cycle + 1] : (long)(track.getSamples().size() + 1))) continue;
                boxes.add(this.createMoof(startSample, endSample, track, sequence));
                boxes.add(this.createMdat(startSample, endSample, track, sequence++));
            }
        }
        return boxes;
    }

    @Override
    public IsoFile build(Movie movie) {
        LOG.fine("Creating movie " + movie);
        IsoFile isoFile = new IsoFile();
        isoFile.addBox(this.createFtyp(movie));
        isoFile.addBox(this.createMoov(movie));
        for (Box box : this.createMoofMdat(movie)) {
            isoFile.addBox(box);
        }
        isoFile.addBox(this.createMfra(movie, isoFile));
        return isoFile;
    }

    protected Box createMdat(final long startSample, final long endSample, final Track track, final int i) {
        class Mdat
        implements Box {
            ContainerBox parent;

            Mdat() {
            }

            @Override
            public ContainerBox getParent() {
                return this.parent;
            }

            @Override
            public void setParent(ContainerBox parent) {
                this.parent = parent;
            }

            @Override
            public long getSize() {
                long size = 8L;
                for (ByteBuffer sample : FragmentedMp4Builder.this.getSamples(startSample, endSample, track, i)) {
                    size += (long)sample.limit();
                }
                return size;
            }

            @Override
            public String getType() {
                return "mdat";
            }

            @Override
            public void getBox(WritableByteChannel writableByteChannel) throws IOException {
                List<ByteBuffer> bbs = FragmentedMp4Builder.this.getSamples(startSample, endSample, track, i);
                List<ByteBuffer> samples = ByteBufferHelper.mergeAdjacentBuffers(bbs);
                ByteBuffer header = ByteBuffer.allocate(8);
                IsoTypeWriter.writeUInt32(header, CastUtils.l2i(this.getSize()));
                header.put(IsoFile.fourCCtoBytes(this.getType()));
                header.rewind();
                writableByteChannel.write(header);
                if (writableByteChannel instanceof GatheringByteChannel) {
                    int STEPSIZE = 1024;
                    int i2 = 0;
                    while ((double)i2 < Math.ceil((double)samples.size() / (double)STEPSIZE)) {
                        List<ByteBuffer> sublist = samples.subList(i2 * STEPSIZE, (i2 + 1) * STEPSIZE < samples.size() ? (i2 + 1) * STEPSIZE : samples.size());
                        ByteBuffer[] sampleArray = sublist.toArray(new ByteBuffer[sublist.size()]);
                        do {
                            ((GatheringByteChannel)writableByteChannel).write(sampleArray);
                        } while (sampleArray[sampleArray.length - 1].remaining() > 0);
                        ++i2;
                    }
                } else {
                    for (ByteBuffer sample : samples) {
                        sample.rewind();
                        writableByteChannel.write(sample);
                    }
                }
            }

            @Override
            public void parse(ReadableByteChannel readableByteChannel, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
            }
        }
        return new Mdat();
    }

    protected Box createTfhd(long startSample, long endSample, Track track, int sequenceNumber) {
        TrackFragmentHeaderBox tfhd = new TrackFragmentHeaderBox();
        SampleFlags sf = new SampleFlags();
        tfhd.setDefaultSampleFlags(sf);
        tfhd.setBaseDataOffset(-1L);
        tfhd.setTrackId(track.getTrackMetaData().getTrackId());
        return tfhd;
    }

    protected Box createMfhd(long startSample, long endSample, Track track, int sequenceNumber) {
        MovieFragmentHeaderBox mfhd = new MovieFragmentHeaderBox();
        mfhd.setSequenceNumber(sequenceNumber);
        return mfhd;
    }

    protected Box createTraf(long startSample, long endSample, Track track, int sequenceNumber) {
        TrackFragmentBox traf = new TrackFragmentBox();
        traf.addBox(this.createTfhd(startSample, endSample, track, sequenceNumber));
        for (Box box : this.createTruns(startSample, endSample, track, sequenceNumber)) {
            traf.addBox(box);
        }
        return traf;
    }

    protected List<ByteBuffer> getSamples(long startSample, long endSample, Track track, int sequenceNumber) {
        return track.getSamples().subList(CastUtils.l2i(startSample) - 1, CastUtils.l2i(endSample) - 1);
    }

    protected long[] getSampleSizes(long startSample, long endSample, Track track, int sequenceNumber) {
        List<ByteBuffer> samples = this.getSamples(startSample, endSample, track, sequenceNumber);
        long[] sampleSizes = new long[samples.size()];
        for (int i = 0; i < sampleSizes.length; ++i) {
            sampleSizes[i] = samples.get(i).limit();
        }
        return sampleSizes;
    }

    protected List<? extends Box> createTruns(long startSample, long endSample, Track track, int sequenceNumber) {
        long left;
        TrackRunBox trun = new TrackRunBox();
        long[] sampleSizes = this.getSampleSizes(startSample, endSample, track, sequenceNumber);
        trun.setSampleDurationPresent(true);
        trun.setSampleSizePresent(true);
        ArrayList<TrackRunBox.Entry> entries = new ArrayList<TrackRunBox.Entry>(CastUtils.l2i(endSample - startSample));
        LinkedList<TimeToSampleBox.Entry> timeQueue = new LinkedList<TimeToSampleBox.Entry>(track.getDecodingTimeEntries());
        long curEntryLeft = ((TimeToSampleBox.Entry)timeQueue.peek()).getCount();
        for (left = startSample - 1L; left > curEntryLeft; left -= curEntryLeft) {
            timeQueue.remove();
            curEntryLeft = ((TimeToSampleBox.Entry)timeQueue.peek()).getCount();
        }
        curEntryLeft -= left;
        LinkedList<CompositionTimeToSample.Entry> compositionTimeQueue = track.getCompositionTimeEntries() != null && track.getCompositionTimeEntries().size() > 0 ? new LinkedList<CompositionTimeToSample.Entry>(track.getCompositionTimeEntries()) : null;
        long compositionTimeEntriesLeft = compositionTimeQueue != null ? (long)((CompositionTimeToSample.Entry)compositionTimeQueue.peek()).getCount() : -1L;
        trun.setSampleCompositionTimeOffsetPresent(compositionTimeEntriesLeft > 0L);
        for (long i = 1L; i < startSample; ++i) {
            if (compositionTimeQueue == null || --compositionTimeEntriesLeft != 0L || compositionTimeQueue.size() <= 1) continue;
            compositionTimeQueue.remove();
            compositionTimeEntriesLeft = ((CompositionTimeToSample.Entry)compositionTimeQueue.element()).getCount();
        }
        boolean sampleFlagsRequired = track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty() || track.getSyncSamples() != null && track.getSyncSamples().length != 0;
        trun.setSampleFlagsPresent(sampleFlagsRequired);
        for (int i = 0; i < sampleSizes.length; ++i) {
            TrackRunBox.Entry entry = new TrackRunBox.Entry();
            entry.setSampleSize(sampleSizes[i]);
            if (sampleFlagsRequired) {
                SampleFlags sflags = new SampleFlags();
                if (track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty()) {
                    SampleDependencyTypeBox.Entry e = track.getSampleDependencies().get(i);
                    sflags.setSampleDependsOn(e.getSampleDependsOn());
                    sflags.setSampleIsDependedOn(e.getSampleIsDependentOn());
                    sflags.setSampleHasRedundancy(e.getSampleHasRedundancy());
                }
                if (track.getSyncSamples() != null && track.getSyncSamples().length > 0) {
                    if (Arrays.binarySearch(track.getSyncSamples(), startSample + (long)i) >= 0) {
                        sflags.setSampleIsDifferenceSample(false);
                        sflags.setSampleDependsOn(2);
                    } else {
                        sflags.setSampleIsDifferenceSample(true);
                        sflags.setSampleDependsOn(1);
                    }
                }
                entry.setSampleFlags(sflags);
            }
            entry.setSampleDuration(((TimeToSampleBox.Entry)timeQueue.peek()).getDelta());
            if (--curEntryLeft == 0L && timeQueue.size() > 1) {
                timeQueue.remove();
                curEntryLeft = ((TimeToSampleBox.Entry)timeQueue.peek()).getCount();
            }
            if (compositionTimeQueue != null) {
                entry.setSampleCompositionTimeOffset(((CompositionTimeToSample.Entry)compositionTimeQueue.peek()).getOffset());
                if (--compositionTimeEntriesLeft == 0L && compositionTimeQueue.size() > 1) {
                    compositionTimeQueue.remove();
                    compositionTimeEntriesLeft = ((CompositionTimeToSample.Entry)compositionTimeQueue.element()).getCount();
                }
            }
            entries.add(entry);
        }
        trun.setEntries(entries);
        return Collections.singletonList(trun);
    }

    protected Box createMoof(long startSample, long endSample, Track track, int sequenceNumber) {
        MovieFragmentBox moof = new MovieFragmentBox();
        moof.addBox(this.createMfhd(startSample, endSample, track, sequenceNumber));
        moof.addBox(this.createTraf(startSample, endSample, track, sequenceNumber));
        TrackRunBox firstTrun = moof.getTrackRunBoxes().get(0);
        firstTrun.setDataOffset(1);
        firstTrun.setDataOffset((int)(8L + moof.getSize()));
        return moof;
    }

    protected Box createMvhd(Movie movie) {
        MovieHeaderBox mvhd = new MovieHeaderBox();
        mvhd.setVersion(1);
        mvhd.setCreationTime(new Date());
        mvhd.setModificationTime(new Date());
        long movieTimeScale = movie.getTimescale();
        long duration = 0L;
        for (Track track : movie.getTracks()) {
            long tracksDuration = this.getDuration(track) * movieTimeScale / track.getTrackMetaData().getTimescale();
            if (tracksDuration <= duration) continue;
            duration = tracksDuration;
        }
        mvhd.setDuration(duration);
        mvhd.setTimescale(movieTimeScale);
        long nextTrackId = 0L;
        for (Track track : movie.getTracks()) {
            nextTrackId = nextTrackId < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : nextTrackId;
        }
        mvhd.setNextTrackId(++nextTrackId);
        return mvhd;
    }

    protected Box createMoov(Movie movie) {
        MovieBox movieBox = new MovieBox();
        movieBox.addBox(this.createMvhd(movie));
        movieBox.addBox(this.createMvex(movie));
        for (Track track : movie.getTracks()) {
            movieBox.addBox(this.createTrak(track, movie));
        }
        return movieBox;
    }

    protected Box createTfra(Track track, IsoFile isoFile) {
        TrackFragmentRandomAccessBox tfra = new TrackFragmentRandomAccessBox();
        tfra.setVersion(1);
        LinkedList<TrackFragmentRandomAccessBox.Entry> offset2timeEntries = new LinkedList<TrackFragmentRandomAccessBox.Entry>();
        List<Box> boxes = isoFile.getBoxes();
        long offset = 0L;
        long duration = 0L;
        for (Box box : boxes) {
            if (box instanceof MovieFragmentBox) {
                List<TrackFragmentBox> trafs = ((MovieFragmentBox)box).getBoxes(TrackFragmentBox.class);
                for (int i = 0; i < trafs.size(); ++i) {
                    TrackFragmentBox traf = trafs.get(i);
                    if (traf.getTrackFragmentHeaderBox().getTrackId() != track.getTrackMetaData().getTrackId()) continue;
                    List<TrackRunBox> truns = traf.getBoxes(TrackRunBox.class);
                    for (int j = 0; j < truns.size(); ++j) {
                        LinkedList<TrackFragmentRandomAccessBox.Entry> offset2timeEntriesThisTrun = new LinkedList<TrackFragmentRandomAccessBox.Entry>();
                        TrackRunBox trun = truns.get(j);
                        for (int k = 0; k < trun.getEntries().size(); ++k) {
                            TrackRunBox.Entry trunEntry = trun.getEntries().get(k);
                            SampleFlags sf = null;
                            if (k == 0 && trun.isFirstSampleFlagsPresent()) {
                                sf = trun.getFirstSampleFlags();
                            } else if (trun.isSampleFlagsPresent()) {
                                sf = trunEntry.getSampleFlags();
                            } else {
                                List<MovieExtendsBox> mvexs = isoFile.getMovieBox().getBoxes(MovieExtendsBox.class);
                                for (MovieExtendsBox mvex : mvexs) {
                                    List<TrackExtendsBox> trexs = mvex.getBoxes(TrackExtendsBox.class);
                                    for (TrackExtendsBox trex : trexs) {
                                        if (trex.getTrackId() != track.getTrackMetaData().getTrackId()) continue;
                                        sf = trex.getDefaultSampleFlags();
                                    }
                                }
                            }
                            if (sf == null) {
                                throw new RuntimeException("Could not find any SampleFlags to indicate random access or not");
                            }
                            if (sf.getSampleDependsOn() == 2) {
                                offset2timeEntriesThisTrun.add(new TrackFragmentRandomAccessBox.Entry(duration, offset, i + 1, j + 1, k + 1));
                            }
                            duration += trunEntry.getSampleDuration();
                        }
                        if (offset2timeEntriesThisTrun.size() == trun.getEntries().size() && trun.getEntries().size() > 0) {
                            offset2timeEntries.add((TrackFragmentRandomAccessBox.Entry)offset2timeEntriesThisTrun.get(0));
                            continue;
                        }
                        offset2timeEntries.addAll(offset2timeEntriesThisTrun);
                    }
                }
            }
            offset += box.getSize();
        }
        tfra.setEntries(offset2timeEntries);
        tfra.setTrackId(track.getTrackMetaData().getTrackId());
        return tfra;
    }

    protected Box createMfra(Movie movie, IsoFile isoFile) {
        MovieFragmentRandomAccessBox mfra = new MovieFragmentRandomAccessBox();
        for (Track track : movie.getTracks()) {
            mfra.addBox(this.createTfra(track, isoFile));
        }
        MovieFragmentRandomAccessOffsetBox mfro = new MovieFragmentRandomAccessOffsetBox();
        mfra.addBox(mfro);
        mfro.setMfraSize(mfra.getSize());
        return mfra;
    }

    protected Box createTrex(Movie movie, Track track) {
        TrackExtendsBox trex = new TrackExtendsBox();
        trex.setTrackId(track.getTrackMetaData().getTrackId());
        trex.setDefaultSampleDescriptionIndex(1L);
        trex.setDefaultSampleDuration(0L);
        trex.setDefaultSampleSize(0L);
        SampleFlags sf = new SampleFlags();
        if ("soun".equals(track.getHandler())) {
            sf.setSampleDependsOn(2);
            sf.setSampleIsDependedOn(2);
        }
        trex.setDefaultSampleFlags(sf);
        return trex;
    }

    protected Box createMvex(Movie movie) {
        MovieExtendsBox mvex = new MovieExtendsBox();
        MovieExtendsHeaderBox mved = new MovieExtendsHeaderBox();
        for (Track track : movie.getTracks()) {
            long trackDuration = this.getTrackDuration(movie, track);
            if (mved.getFragmentDuration() >= trackDuration) continue;
            mved.setFragmentDuration(trackDuration);
        }
        mvex.addBox(mved);
        for (Track track : movie.getTracks()) {
            mvex.addBox(this.createTrex(movie, track));
        }
        return mvex;
    }

    protected Box createTkhd(Movie movie, Track track) {
        TrackHeaderBox tkhd = new TrackHeaderBox();
        tkhd.setVersion(1);
        int flags = 0;
        if (track.isEnabled()) {
            ++flags;
        }
        if (track.isInMovie()) {
            flags += 2;
        }
        if (track.isInPreview()) {
            flags += 4;
        }
        if (track.isInPoster()) {
            flags += 8;
        }
        tkhd.setFlags(flags);
        tkhd.setAlternateGroup(track.getTrackMetaData().getGroup());
        tkhd.setCreationTime(track.getTrackMetaData().getCreationTime());
        tkhd.setDuration(this.getTrackDuration(movie, track));
        tkhd.setHeight(track.getTrackMetaData().getHeight());
        tkhd.setWidth(track.getTrackMetaData().getWidth());
        tkhd.setLayer(track.getTrackMetaData().getLayer());
        tkhd.setModificationTime(new Date());
        tkhd.setTrackId(track.getTrackMetaData().getTrackId());
        tkhd.setVolume(track.getTrackMetaData().getVolume());
        return tkhd;
    }

    private long getTrackDuration(Movie movie, Track track) {
        return this.getDuration(track) * movie.getTimescale() / track.getTrackMetaData().getTimescale();
    }

    protected Box createMdhd(Movie movie, Track track) {
        MediaHeaderBox mdhd = new MediaHeaderBox();
        mdhd.setCreationTime(track.getTrackMetaData().getCreationTime());
        mdhd.setDuration(this.getDuration(track));
        mdhd.setTimescale(track.getTrackMetaData().getTimescale());
        mdhd.setLanguage(track.getTrackMetaData().getLanguage());
        return mdhd;
    }

    protected Box createStbl(Movie movie, Track track) {
        SampleTableBox stbl = new SampleTableBox();
        stbl.addBox(track.getSampleDescriptionBox());
        stbl.addBox(new TimeToSampleBox());
        stbl.addBox(new StaticChunkOffsetBox());
        return stbl;
    }

    protected Box createMinf(Track track, Movie movie) {
        MediaInformationBox minf = new MediaInformationBox();
        minf.addBox(track.getMediaHeaderBox());
        minf.addBox(this.createDinf(movie, track));
        minf.addBox(this.createStbl(movie, track));
        return minf;
    }

    protected Box createMdiaHdlr(Track track, Movie movie) {
        HandlerBox hdlr = new HandlerBox();
        hdlr.setHandlerType(track.getHandler());
        return hdlr;
    }

    protected Box createMdia(Track track, Movie movie) {
        MediaBox mdia = new MediaBox();
        mdia.addBox(this.createMdhd(movie, track));
        mdia.addBox(this.createMdiaHdlr(track, movie));
        mdia.addBox(this.createMinf(track, movie));
        return mdia;
    }

    protected Box createTrak(Track track, Movie movie) {
        LOG.fine("Creating Track " + track);
        TrackBox trackBox = new TrackBox();
        trackBox.addBox(this.createTkhd(movie, track));
        trackBox.addBox(this.createMdia(track, movie));
        return trackBox;
    }

    protected DataInformationBox createDinf(Movie movie, Track track) {
        DataInformationBox dinf = new DataInformationBox();
        DataReferenceBox dref = new DataReferenceBox();
        dinf.addBox(dref);
        DataEntryUrlBox url = new DataEntryUrlBox();
        url.setFlags(1);
        dref.addBox(url);
        return dinf;
    }

    public FragmentIntersectionFinder getFragmentIntersectionFinder() {
        return this.intersectionFinder;
    }

    public void setIntersectionFinder(FragmentIntersectionFinder intersectionFinder) {
        this.intersectionFinder = intersectionFinder;
    }

    protected long getDuration(Track track) {
        long duration = 0L;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            duration += entry.getCount() * entry.getDelta();
        }
        return duration;
    }
}

