/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.util.ByteBufferByteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public abstract class FullContainerBox
extends AbstractFullBox
implements ContainerBox {
    private static Logger LOG = Logger.getLogger(FullContainerBox.class.getName());
    protected List<Box> boxes = new LinkedList<Box>();
    BoxParser boxParser;

    public FullContainerBox(String type) {
        super(type);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean recursive) {
        ArrayList<Box> boxesToBeReturned = new ArrayList<Box>(2);
        for (Box boxe : this.boxes) {
            if (clazz == boxe.getClass()) {
                boxesToBeReturned.add(boxe);
            }
            if (!recursive || !(boxe instanceof ContainerBox)) continue;
            boxesToBeReturned.addAll(((ContainerBox)boxe).getBoxes(clazz, recursive));
        }
        return boxesToBeReturned;
    }

    @Override
    protected long getContentSize() {
        long contentSize = 4L;
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    public void addBox(Box b) {
        b.setParent(this);
        this.boxes.add(b);
    }

    public void removeBox(Box b) {
        b.setParent(null);
        this.boxes.remove(b);
    }

    @Override
    public List<Box> getBoxes() {
        return this.boxes;
    }

    @Override
    public void setBoxes(List<Box> boxes) {
        this.boxes = new LinkedList<Box>(boxes);
    }

    @Override
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        this.boxParser = boxParser;
        super.parse(readableByteChannel, header, contentSize, boxParser);
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.parseChildBoxes(content);
    }

    protected final void parseChildBoxes(ByteBuffer content) {
        try {
            while (content.remaining() >= 8) {
                this.boxes.add(this.boxParser.parseBox(new ByteBufferByteChannel(content), this));
            }
            if (content.remaining() != 0) {
                this.setDeadBytes(content.slice());
                LOG.severe("Some sizes are wrong");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName()).append("[");
        for (int i = 0; i < this.boxes.size(); ++i) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(this.boxes.get(i).toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        this.writeChildBoxes(byteBuffer);
    }

    protected final void writeChildBoxes(ByteBuffer bb) {
        ByteBufferByteChannel wbc = new ByteBufferByteChannel(bb);
        for (Box box : this.boxes) {
            try {
                box.getBox(wbc);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot happen.", e);
            }
        }
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        long sizeOfChildren = 0L;
        for (Box box : this.boxes) {
            sizeOfChildren += box.getSize();
        }
        return this.getSize() - sizeOfChildren;
    }
}

