/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.io.packets;

import com.github.faucamp.simplertmp.Util;
import com.github.faucamp.simplertmp.io.ChunkStreamInfo;
import com.github.faucamp.simplertmp.io.packets.RtmpHeader;
import com.github.faucamp.simplertmp.io.packets.RtmpPacket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class SetPeerBandwidth
extends RtmpPacket {
    private int acknowledgementWindowSize;
    private LimitType limitType;

    public SetPeerBandwidth(RtmpHeader header) {
        super(header);
    }

    public SetPeerBandwidth(int acknowledgementWindowSize, LimitType limitType, ChunkStreamInfo channelInfo) {
        super(new RtmpHeader(channelInfo.canReusePrevHeaderTx(RtmpHeader.MessageType.SET_PEER_BANDWIDTH) ? RtmpHeader.ChunkType.TYPE_2_RELATIVE_TIMESTAMP_ONLY : RtmpHeader.ChunkType.TYPE_0_FULL, 2, RtmpHeader.MessageType.WINDOW_ACKNOWLEDGEMENT_SIZE));
        this.acknowledgementWindowSize = acknowledgementWindowSize;
        this.limitType = limitType;
    }

    public int getAcknowledgementWindowSize() {
        return this.acknowledgementWindowSize;
    }

    public void setAcknowledgementWindowSize(int acknowledgementWindowSize) {
        this.acknowledgementWindowSize = acknowledgementWindowSize;
    }

    public LimitType getLimitType() {
        return this.limitType;
    }

    public void setLimitType(LimitType limitType) {
        this.limitType = limitType;
    }

    @Override
    public void readBody(InputStream in) throws IOException {
        this.acknowledgementWindowSize = Util.readUnsignedInt32(in);
        this.limitType = LimitType.valueOf(in.read());
    }

    @Override
    protected void writeBody(OutputStream out) throws IOException {
        Util.writeUnsignedInt32(out, this.acknowledgementWindowSize);
        out.write(this.limitType.getIntValue());
    }

    @Override
    protected byte[] array() {
        return null;
    }

    @Override
    protected int size() {
        return 0;
    }

    public String toString() {
        return "RTMP Set Peer Bandwidth";
    }

    public static enum LimitType {
        HARD(0),
        SOFT(1),
        DYNAMIC(2);

        private static final Map<Integer, LimitType> quickLookupMap;
        private int intValue;

        private LimitType(int intValue) {
            this.intValue = intValue;
        }

        public static LimitType valueOf(int intValue) {
            return quickLookupMap.get(intValue);
        }

        public int getIntValue() {
            return this.intValue;
        }

        static {
            quickLookupMap = new HashMap<Integer, LimitType>();
            for (LimitType type : LimitType.values()) {
                quickLookupMap.put(type.getIntValue(), type);
            }
        }
    }
}

