/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.io.packets;

import com.github.faucamp.simplertmp.Util;
import com.github.faucamp.simplertmp.io.ChunkStreamInfo;
import com.github.faucamp.simplertmp.io.RtmpSessionInfo;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class RtmpHeader {
    private static final String TAG = "RtmpHeader";
    private ChunkType chunkType;
    private int chunkStreamId;
    private int absoluteTimestamp;
    private int timestampDelta = -1;
    private int packetLength;
    private MessageType messageType;
    private int messageStreamId;
    private int extendedTimestamp;

    public RtmpHeader() {
    }

    public RtmpHeader(ChunkType chunkType, int chunkStreamId, MessageType messageType) {
        this.chunkType = chunkType;
        this.chunkStreamId = chunkStreamId;
        this.messageType = messageType;
    }

    public static RtmpHeader readHeader(InputStream in, RtmpSessionInfo rtmpSessionInfo) throws IOException {
        RtmpHeader rtmpHeader = new RtmpHeader();
        rtmpHeader.readHeaderImpl(in, rtmpSessionInfo);
        return rtmpHeader;
    }

    private void readHeaderImpl(InputStream in, RtmpSessionInfo rtmpSessionInfo) throws IOException {
        int basicHeaderByte = in.read();
        if (basicHeaderByte == -1) {
            throw new EOFException("Unexpected EOF while reading RTMP packet basic header");
        }
        this.parseBasicHeader((byte)basicHeaderByte);
        switch (this.chunkType) {
            case TYPE_0_FULL: {
                this.absoluteTimestamp = Util.readUnsignedInt24(in);
                this.timestampDelta = 0;
                this.packetLength = Util.readUnsignedInt24(in);
                this.messageType = MessageType.valueOf((byte)in.read());
                byte[] messageStreamIdBytes = new byte[4];
                Util.readBytesUntilFull(in, messageStreamIdBytes);
                this.messageStreamId = Util.toUnsignedInt32LittleEndian(messageStreamIdBytes);
                int n = this.extendedTimestamp = this.absoluteTimestamp >= 0xFFFFFF ? Util.readUnsignedInt32(in) : 0;
                if (this.extendedTimestamp == 0) break;
                this.absoluteTimestamp = this.extendedTimestamp;
                break;
            }
            case TYPE_1_RELATIVE_LARGE: {
                this.timestampDelta = Util.readUnsignedInt24(in);
                this.packetLength = Util.readUnsignedInt24(in);
                this.messageType = MessageType.valueOf((byte)in.read());
                this.extendedTimestamp = this.timestampDelta >= 0xFFFFFF ? Util.readUnsignedInt32(in) : 0;
                RtmpHeader prevHeader = rtmpSessionInfo.getChunkStreamInfo(this.chunkStreamId).prevHeaderRx();
                if (prevHeader != null) {
                    this.messageStreamId = prevHeader.messageStreamId;
                    this.absoluteTimestamp = this.extendedTimestamp != 0 ? this.extendedTimestamp : prevHeader.absoluteTimestamp + this.timestampDelta;
                    break;
                }
                this.messageStreamId = 0;
                this.absoluteTimestamp = this.extendedTimestamp != 0 ? this.extendedTimestamp : this.timestampDelta;
                break;
            }
            case TYPE_2_RELATIVE_TIMESTAMP_ONLY: {
                this.timestampDelta = Util.readUnsignedInt24(in);
                this.extendedTimestamp = this.timestampDelta >= 0xFFFFFF ? Util.readUnsignedInt32(in) : 0;
                RtmpHeader prevHeader = rtmpSessionInfo.getChunkStreamInfo(this.chunkStreamId).prevHeaderRx();
                this.packetLength = prevHeader.packetLength;
                this.messageType = prevHeader.messageType;
                this.messageStreamId = prevHeader.messageStreamId;
                this.absoluteTimestamp = this.extendedTimestamp != 0 ? this.extendedTimestamp : prevHeader.absoluteTimestamp + this.timestampDelta;
                break;
            }
            case TYPE_3_RELATIVE_SINGLE_BYTE: {
                RtmpHeader prevHeader = rtmpSessionInfo.getChunkStreamInfo(this.chunkStreamId).prevHeaderRx();
                this.extendedTimestamp = prevHeader.timestampDelta >= 0xFFFFFF ? Util.readUnsignedInt32(in) : 0;
                this.timestampDelta = this.extendedTimestamp != 0 ? 0xFFFFFF : prevHeader.timestampDelta;
                this.packetLength = prevHeader.packetLength;
                this.messageType = prevHeader.messageType;
                this.messageStreamId = prevHeader.messageStreamId;
                this.absoluteTimestamp = this.extendedTimestamp != 0 ? this.extendedTimestamp : prevHeader.absoluteTimestamp + this.timestampDelta;
                break;
            }
            default: {
                throw new IOException("Invalid chunk type; basic header byte was: " + Util.toHexString((byte)basicHeaderByte));
            }
        }
    }

    public void writeTo(OutputStream out, ChunkType chunkType, ChunkStreamInfo chunkStreamInfo) throws IOException {
        out.write((byte)(chunkType.getValue() << 6) | this.chunkStreamId);
        switch (chunkType) {
            case TYPE_0_FULL: {
                chunkStreamInfo.markDeltaTimestampTx();
                Util.writeUnsignedInt24(out, this.absoluteTimestamp >= 0xFFFFFF ? 0xFFFFFF : this.absoluteTimestamp);
                Util.writeUnsignedInt24(out, this.packetLength);
                out.write(this.messageType.getValue());
                Util.writeUnsignedInt32LittleEndian(out, this.messageStreamId);
                if (this.absoluteTimestamp < 0xFFFFFF) break;
                this.extendedTimestamp = this.absoluteTimestamp;
                Util.writeUnsignedInt32(out, this.extendedTimestamp);
                break;
            }
            case TYPE_1_RELATIVE_LARGE: {
                this.timestampDelta = (int)chunkStreamInfo.markDeltaTimestampTx();
                this.absoluteTimestamp = chunkStreamInfo.getPrevHeaderTx().getAbsoluteTimestamp() + this.timestampDelta;
                Util.writeUnsignedInt24(out, this.absoluteTimestamp >= 0xFFFFFF ? 0xFFFFFF : this.timestampDelta);
                Util.writeUnsignedInt24(out, this.packetLength);
                out.write(this.messageType.getValue());
                if (this.absoluteTimestamp < 0xFFFFFF) break;
                this.extendedTimestamp = this.absoluteTimestamp;
                Util.writeUnsignedInt32(out, this.absoluteTimestamp);
                break;
            }
            case TYPE_2_RELATIVE_TIMESTAMP_ONLY: {
                this.timestampDelta = (int)chunkStreamInfo.markDeltaTimestampTx();
                this.absoluteTimestamp = chunkStreamInfo.getPrevHeaderTx().getAbsoluteTimestamp() + this.timestampDelta;
                Util.writeUnsignedInt24(out, this.absoluteTimestamp >= 0xFFFFFF ? 0xFFFFFF : this.timestampDelta);
                if (this.absoluteTimestamp < 0xFFFFFF) break;
                this.extendedTimestamp = this.absoluteTimestamp;
                Util.writeUnsignedInt32(out, this.extendedTimestamp);
                break;
            }
            case TYPE_3_RELATIVE_SINGLE_BYTE: {
                if (this.extendedTimestamp <= 0) break;
                Util.writeUnsignedInt32(out, this.extendedTimestamp);
                break;
            }
            default: {
                throw new IOException("Invalid chunk type: " + (Object)((Object)chunkType));
            }
        }
    }

    private void parseBasicHeader(byte basicHeaderByte) {
        this.chunkType = ChunkType.valueOf((byte)((0xFF & basicHeaderByte) >>> 6));
        this.chunkStreamId = basicHeaderByte & 0x3F;
    }

    public int getChunkStreamId() {
        return this.chunkStreamId;
    }

    public void setChunkStreamId(int channelId) {
        this.chunkStreamId = channelId;
    }

    public ChunkType getChunkType() {
        return this.chunkType;
    }

    public void setChunkType(ChunkType chunkType) {
        this.chunkType = chunkType;
    }

    public int getPacketLength() {
        return this.packetLength;
    }

    public void setPacketLength(int packetLength) {
        this.packetLength = packetLength;
    }

    public int getMessageStreamId() {
        return this.messageStreamId;
    }

    public void setMessageStreamId(int messageStreamId) {
        this.messageStreamId = messageStreamId;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public int getAbsoluteTimestamp() {
        return this.absoluteTimestamp;
    }

    public void setAbsoluteTimestamp(int absoluteTimestamp) {
        this.absoluteTimestamp = absoluteTimestamp;
    }

    public int getTimestampDelta() {
        return this.timestampDelta;
    }

    public void setTimestampDelta(int timestampDelta) {
        this.timestampDelta = timestampDelta;
    }

    public static enum ChunkType {
        TYPE_0_FULL(0),
        TYPE_1_RELATIVE_LARGE(1),
        TYPE_2_RELATIVE_TIMESTAMP_ONLY(2),
        TYPE_3_RELATIVE_SINGLE_BYTE(3);

        private static final Map<Byte, ChunkType> quickLookupMap;
        private byte value;

        private ChunkType(int byteValue) {
            this.value = (byte)byteValue;
        }

        public static ChunkType valueOf(byte chunkHeaderType) {
            if (quickLookupMap.containsKey(chunkHeaderType)) {
                return quickLookupMap.get(chunkHeaderType);
            }
            throw new IllegalArgumentException("Unknown chunk header type byte: " + Util.toHexString(chunkHeaderType));
        }

        public byte getValue() {
            return this.value;
        }

        static {
            quickLookupMap = new HashMap<Byte, ChunkType>();
            for (ChunkType messageTypId : ChunkType.values()) {
                quickLookupMap.put(messageTypId.getValue(), messageTypId);
            }
        }
    }

    public static enum MessageType {
        SET_CHUNK_SIZE(1),
        ABORT(2),
        ACKNOWLEDGEMENT(3),
        USER_CONTROL_MESSAGE(4),
        WINDOW_ACKNOWLEDGEMENT_SIZE(5),
        SET_PEER_BANDWIDTH(6),
        AUDIO(8),
        VIDEO(9),
        DATA_AMF3(15),
        SHARED_OBJECT_AMF3(16),
        COMMAND_AMF3(17),
        DATA_AMF0(18),
        COMMAND_AMF0(20),
        SHARED_OBJECT_AMF0(19),
        AGGREGATE_MESSAGE(22);

        private static final Map<Byte, MessageType> quickLookupMap;
        private byte value;

        private MessageType(int value) {
            this.value = (byte)value;
        }

        public static MessageType valueOf(byte messageTypeId) {
            if (quickLookupMap.containsKey(messageTypeId)) {
                return quickLookupMap.get(messageTypeId);
            }
            throw new IllegalArgumentException("Unknown message type byte: " + Util.toHexString(messageTypeId));
        }

        public byte getValue() {
            return this.value;
        }

        static {
            quickLookupMap = new HashMap<Byte, MessageType>();
            for (MessageType messageTypId : MessageType.values()) {
                quickLookupMap.put(messageTypId.getValue(), messageTypId);
            }
        }
    }
}

