/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.io.packets;

import com.github.faucamp.simplertmp.Util;
import com.github.faucamp.simplertmp.io.packets.RtmpHeader;
import com.github.faucamp.simplertmp.io.packets.RtmpPacket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Acknowledgement
extends RtmpPacket {
    private int sequenceNumber;

    public Acknowledgement(RtmpHeader header) {
        super(header);
    }

    public Acknowledgement(int numBytesReadThusFar) {
        super(new RtmpHeader(RtmpHeader.ChunkType.TYPE_0_FULL, 2, RtmpHeader.MessageType.ACKNOWLEDGEMENT));
        this.sequenceNumber = numBytesReadThusFar;
    }

    public int getAcknowledgementWindowSize() {
        return this.sequenceNumber;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int numBytesRead) {
        this.sequenceNumber = numBytesRead;
    }

    @Override
    public void readBody(InputStream in) throws IOException {
        this.sequenceNumber = Util.readUnsignedInt32(in);
    }

    @Override
    protected void writeBody(OutputStream out) throws IOException {
        Util.writeUnsignedInt32(out, this.sequenceNumber);
    }

    @Override
    protected byte[] array() {
        return null;
    }

    @Override
    protected int size() {
        return 0;
    }

    public String toString() {
        return "RTMP Acknowledgment (sequence number: " + this.sequenceNumber + ")";
    }
}

