/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.io;

import android.util.Log;
import com.github.faucamp.simplertmp.io.ChunkStreamInfo;
import com.github.faucamp.simplertmp.io.RtmpSessionInfo;
import com.github.faucamp.simplertmp.io.packets.Abort;
import com.github.faucamp.simplertmp.io.packets.Acknowledgement;
import com.github.faucamp.simplertmp.io.packets.Audio;
import com.github.faucamp.simplertmp.io.packets.Command;
import com.github.faucamp.simplertmp.io.packets.Data;
import com.github.faucamp.simplertmp.io.packets.RtmpHeader;
import com.github.faucamp.simplertmp.io.packets.RtmpPacket;
import com.github.faucamp.simplertmp.io.packets.SetChunkSize;
import com.github.faucamp.simplertmp.io.packets.SetPeerBandwidth;
import com.github.faucamp.simplertmp.io.packets.UserControl;
import com.github.faucamp.simplertmp.io.packets.Video;
import com.github.faucamp.simplertmp.io.packets.WindowAckSize;
import java.io.IOException;
import java.io.InputStream;

public class RtmpDecoder {
    private static final String TAG = "RtmpDecoder";
    private RtmpSessionInfo rtmpSessionInfo;

    public RtmpDecoder(RtmpSessionInfo rtmpSessionInfo) {
        this.rtmpSessionInfo = rtmpSessionInfo;
    }

    public RtmpPacket readPacket(InputStream in) throws IOException {
        RtmpPacket rtmpPacket;
        RtmpHeader header = RtmpHeader.readHeader(in, this.rtmpSessionInfo);
        ChunkStreamInfo chunkStreamInfo = this.rtmpSessionInfo.getChunkStreamInfo(header.getChunkStreamId());
        chunkStreamInfo.setPrevHeaderRx(header);
        if (header.getPacketLength() > this.rtmpSessionInfo.getRxChunkSize()) {
            if (!chunkStreamInfo.storePacketChunk(in, this.rtmpSessionInfo.getRxChunkSize())) {
                return null;
            }
            in = chunkStreamInfo.getStoredPacketInputStream();
        }
        switch (header.getMessageType()) {
            case SET_CHUNK_SIZE: {
                SetChunkSize setChunkSize = new SetChunkSize(header);
                setChunkSize.readBody(in);
                Log.d((String)TAG, (String)("readPacket(): Setting chunk size to: " + setChunkSize.getChunkSize()));
                this.rtmpSessionInfo.setRxChunkSize(setChunkSize.getChunkSize());
                return null;
            }
            case ABORT: {
                rtmpPacket = new Abort(header);
                break;
            }
            case USER_CONTROL_MESSAGE: {
                rtmpPacket = new UserControl(header);
                break;
            }
            case WINDOW_ACKNOWLEDGEMENT_SIZE: {
                rtmpPacket = new WindowAckSize(header);
                break;
            }
            case SET_PEER_BANDWIDTH: {
                rtmpPacket = new SetPeerBandwidth(header);
                break;
            }
            case AUDIO: {
                rtmpPacket = new Audio(header);
                break;
            }
            case VIDEO: {
                rtmpPacket = new Video(header);
                break;
            }
            case COMMAND_AMF0: {
                rtmpPacket = new Command(header);
                break;
            }
            case DATA_AMF0: {
                rtmpPacket = new Data(header);
                break;
            }
            case ACKNOWLEDGEMENT: {
                rtmpPacket = new Acknowledgement(header);
                break;
            }
            default: {
                throw new IOException("No packet body implementation for message type: " + (Object)((Object)header.getMessageType()));
            }
        }
        rtmpPacket.readBody(in);
        return rtmpPacket;
    }
}

