/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp;

import com.github.faucamp.simplertmp.util.L;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    private Mac hmacSHA256;

    public Crypto() {
        try {
            this.hmacSHA256 = Mac.getInstance("HmacSHA256");
        }
        catch (SecurityException e) {
            L.e("Security exception when getting HMAC", e);
        }
        catch (NoSuchAlgorithmException e) {
            L.e("HMAC SHA256 does not exist");
        }
    }

    public byte[] calculateHmacSHA256(byte[] input, byte[] key) {
        byte[] output = null;
        try {
            this.hmacSHA256.init(new SecretKeySpec(key, "HmacSHA256"));
            output = this.hmacSHA256.doFinal(input);
        }
        catch (InvalidKeyException e) {
            L.e("Invalid key", e);
        }
        return output;
    }

    public byte[] calculateHmacSHA256(byte[] input, byte[] key, int length) {
        byte[] output = null;
        try {
            this.hmacSHA256.init(new SecretKeySpec(key, 0, length, "HmacSHA256"));
            output = this.hmacSHA256.doFinal(input);
        }
        catch (InvalidKeyException e) {
            L.e("Invalid key", e);
        }
        return output;
    }
}

