/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.nio.ByteBuffer;

public class TextSampleEntry
extends SampleEntry {
    public static final String TYPE1 = "tx3g";
    public static final String TYPE_ENCRYPTED = "enct";
    private long displayFlags;
    private int horizontalJustification;
    private int verticalJustification;
    private int[] backgroundColorRgba = new int[4];
    private BoxRecord boxRecord = new BoxRecord();
    private StyleRecord styleRecord = new StyleRecord();

    public TextSampleEntry(String type) {
        super(type);
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this._parseReservedAndDataReferenceIndex(content);
        this.displayFlags = IsoTypeReader.readUInt32(content);
        this.horizontalJustification = IsoTypeReader.readUInt8(content);
        this.verticalJustification = IsoTypeReader.readUInt8(content);
        this.backgroundColorRgba = new int[4];
        this.backgroundColorRgba[0] = IsoTypeReader.readUInt8(content);
        this.backgroundColorRgba[1] = IsoTypeReader.readUInt8(content);
        this.backgroundColorRgba[2] = IsoTypeReader.readUInt8(content);
        this.backgroundColorRgba[3] = IsoTypeReader.readUInt8(content);
        this.boxRecord = new BoxRecord();
        this.boxRecord.parse(content);
        this.styleRecord = new StyleRecord();
        this.styleRecord.parse(content);
        this._parseChildBoxes(content);
    }

    @Override
    protected long getContentSize() {
        long contentSize = 18L;
        contentSize += (long)this.boxRecord.getSize();
        contentSize += (long)this.styleRecord.getSize();
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    public String toString() {
        return "TextSampleEntry";
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this._writeReservedAndDataReferenceIndex(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.displayFlags);
        IsoTypeWriter.writeUInt8(byteBuffer, this.horizontalJustification);
        IsoTypeWriter.writeUInt8(byteBuffer, this.verticalJustification);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[0]);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[1]);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[2]);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[3]);
        this.boxRecord.getContent(byteBuffer);
        this.styleRecord.getContent(byteBuffer);
        this._writeChildBoxes(byteBuffer);
    }

    public BoxRecord getBoxRecord() {
        return this.boxRecord;
    }

    public void setBoxRecord(BoxRecord boxRecord) {
        this.boxRecord = boxRecord;
    }

    public StyleRecord getStyleRecord() {
        return this.styleRecord;
    }

    public void setStyleRecord(StyleRecord styleRecord) {
        this.styleRecord = styleRecord;
    }

    public boolean isScrollIn() {
        return (this.displayFlags & 0x20L) == 32L;
    }

    public void setScrollIn(boolean scrollIn) {
        this.displayFlags = scrollIn ? (this.displayFlags |= 0x20L) : (this.displayFlags &= 0xFFFFFFFFFFFFFFDFL);
    }

    public boolean isScrollOut() {
        return (this.displayFlags & 0x40L) == 64L;
    }

    public void setScrollOut(boolean scrollOutIn) {
        this.displayFlags = scrollOutIn ? (this.displayFlags |= 0x40L) : (this.displayFlags &= 0xFFFFFFFFFFFFFFBFL);
    }

    public boolean isScrollDirection() {
        return (this.displayFlags & 0x180L) == 384L;
    }

    public void setScrollDirection(boolean scrollOutIn) {
        this.displayFlags = scrollOutIn ? (this.displayFlags |= 0x180L) : (this.displayFlags &= 0xFFFFFFFFFFFFFE7FL);
    }

    public boolean isContinuousKaraoke() {
        return (this.displayFlags & 0x800L) == 2048L;
    }

    public void setContinuousKaraoke(boolean continuousKaraoke) {
        this.displayFlags = continuousKaraoke ? (this.displayFlags |= 0x800L) : (this.displayFlags &= 0xFFFFFFFFFFFFF7FFL);
    }

    public boolean isWriteTextVertically() {
        return (this.displayFlags & 0x20000L) == 131072L;
    }

    public void setWriteTextVertically(boolean writeTextVertically) {
        this.displayFlags = writeTextVertically ? (this.displayFlags |= 0x20000L) : (this.displayFlags &= 0xFFFFFFFFFFFDFFFFL);
    }

    public boolean isFillTextRegion() {
        return (this.displayFlags & 0x40000L) == 262144L;
    }

    public void setFillTextRegion(boolean fillTextRegion) {
        this.displayFlags = fillTextRegion ? (this.displayFlags |= 0x40000L) : (this.displayFlags &= 0xFFFFFFFFFFFBFFFFL);
    }

    public int getHorizontalJustification() {
        return this.horizontalJustification;
    }

    public void setHorizontalJustification(int horizontalJustification) {
        this.horizontalJustification = horizontalJustification;
    }

    public int getVerticalJustification() {
        return this.verticalJustification;
    }

    public void setVerticalJustification(int verticalJustification) {
        this.verticalJustification = verticalJustification;
    }

    public int[] getBackgroundColorRgba() {
        return this.backgroundColorRgba;
    }

    public void setBackgroundColorRgba(int[] backgroundColorRgba) {
        this.backgroundColorRgba = backgroundColorRgba;
    }

    public static class StyleRecord {
        int startChar;
        int endChar;
        int fontId;
        int faceStyleFlags;
        int fontSize;
        int[] textColor = new int[]{255, 255, 255, 255};

        public void parse(ByteBuffer in) {
            this.startChar = IsoTypeReader.readUInt16(in);
            this.endChar = IsoTypeReader.readUInt16(in);
            this.fontId = IsoTypeReader.readUInt16(in);
            this.faceStyleFlags = IsoTypeReader.readUInt8(in);
            this.fontSize = IsoTypeReader.readUInt8(in);
            this.textColor = new int[4];
            this.textColor[0] = IsoTypeReader.readUInt8(in);
            this.textColor[1] = IsoTypeReader.readUInt8(in);
            this.textColor[2] = IsoTypeReader.readUInt8(in);
            this.textColor[3] = IsoTypeReader.readUInt8(in);
        }

        public void getContent(ByteBuffer bb) {
            IsoTypeWriter.writeUInt16(bb, this.startChar);
            IsoTypeWriter.writeUInt16(bb, this.endChar);
            IsoTypeWriter.writeUInt16(bb, this.fontId);
            IsoTypeWriter.writeUInt8(bb, this.faceStyleFlags);
            IsoTypeWriter.writeUInt8(bb, this.fontSize);
            IsoTypeWriter.writeUInt8(bb, this.textColor[0]);
            IsoTypeWriter.writeUInt8(bb, this.textColor[1]);
            IsoTypeWriter.writeUInt8(bb, this.textColor[2]);
            IsoTypeWriter.writeUInt8(bb, this.textColor[3]);
        }

        public int getSize() {
            return 12;
        }
    }

    public static class BoxRecord {
        int top;
        int left;
        int bottom;
        int right;

        public void parse(ByteBuffer in) {
            this.top = IsoTypeReader.readUInt16(in);
            this.left = IsoTypeReader.readUInt16(in);
            this.bottom = IsoTypeReader.readUInt16(in);
            this.right = IsoTypeReader.readUInt16(in);
        }

        public void getContent(ByteBuffer bb) {
            IsoTypeWriter.writeUInt16(bb, this.top);
            IsoTypeWriter.writeUInt16(bb, this.left);
            IsoTypeWriter.writeUInt16(bb, this.bottom);
            IsoTypeWriter.writeUInt16(bb, this.right);
        }

        public int getSize() {
            return 8;
        }
    }
}

