/*
 * Decompiled with CFR 0.152.
 */
package ir.mstajbakhsh.livehiddencamera.LiveBroadcaster;

import android.os.Handler;
import android.os.Message;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class SrsRecordHandler
extends Handler {
    private static final int MSG_RECORD_PAUSE = 0;
    private static final int MSG_RECORD_RESUME = 1;
    private static final int MSG_RECORD_STARTED = 2;
    private static final int MSG_RECORD_FINISHED = 3;
    private static final int MSG_RECORD_ILLEGEL_ARGUMENT_EXCEPTION = 4;
    private static final int MSG_RECORD_IO_EXCEPTION = 5;
    private WeakReference<SrsRecordListener> mWeakListener;

    public SrsRecordHandler(SrsRecordListener listener) {
        this.mWeakListener = new WeakReference<SrsRecordListener>(listener);
    }

    public void notifyRecordPause() {
        this.sendEmptyMessage(0);
    }

    public void notifyRecordResume() {
        this.sendEmptyMessage(1);
    }

    public void notifyRecordStarted(String msg) {
        this.obtainMessage(2, msg).sendToTarget();
    }

    public void notifyRecordFinished(String msg) {
        this.obtainMessage(3, msg).sendToTarget();
    }

    public void notifyRecordIllegalArgumentException(IllegalArgumentException e) {
        this.obtainMessage(4, e).sendToTarget();
    }

    public void notifyRecordIOException(IOException e) {
        this.obtainMessage(5, e).sendToTarget();
    }

    public void handleMessage(Message msg) {
        SrsRecordListener listener = (SrsRecordListener)this.mWeakListener.get();
        if (listener == null) {
            return;
        }
        switch (msg.what) {
            case 0: {
                listener.onRecordPause();
                break;
            }
            case 1: {
                listener.onRecordResume();
                break;
            }
            case 2: {
                listener.onRecordStarted((String)msg.obj);
                break;
            }
            case 3: {
                listener.onRecordFinished((String)msg.obj);
                break;
            }
            case 4: {
                listener.onRecordIllegalArgumentException((IllegalArgumentException)msg.obj);
                break;
            }
            case 5: {
                listener.onRecordIOException((IOException)msg.obj);
                break;
            }
            default: {
                throw new RuntimeException("unknown msg " + msg.what);
            }
        }
    }

    public static interface SrsRecordListener {
        public void onRecordPause();

        public void onRecordResume();

        public void onRecordStarted(String var1);

        public void onRecordFinished(String var1);

        public void onRecordIllegalArgumentException(IllegalArgumentException var1);

        public void onRecordIOException(IOException var1);
    }
}

