/*
 * Decompiled with CFR 0.152.
 */
package ir.mstajbakhsh.livehiddencamera.LiveBroadcaster;

import android.app.Activity;
import android.content.Context;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.view.SurfaceHolder;
import ir.mstajbakhsh.livehiddencamera.HiddenCameraLayout.CameraPreview;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SrsCameraView
extends CameraPreview
implements SurfaceHolder.Callback,
Camera.PreviewCallback {
    private final Object writeLock = new Object();
    private int mPreviewWidth;
    private int mPreviewHeight;
    private volatile boolean mIsEncoding;
    private Camera mCamera;
    private ByteBuffer mGLPreviewBuffer;
    private int mCamId = -1;
    private int mPreviewRotation = 90;
    private int mPreviewOrientation = 1;
    private Thread worker;
    private ConcurrentLinkedQueue<IntBuffer> mGLIntBufferCache = new ConcurrentLinkedQueue();
    private PreviewCallback mPrevCb;
    private CameraCallbacksHandler cameraCallbacksHandler = new CameraCallbacksHandler();

    public SrsCameraView(Context context) {
        super(context);
    }

    public void setPreviewCallback(PreviewCallback cb) {
        this.mPrevCb = cb;
    }

    public Camera getCamera() {
        return this.mCamera;
    }

    public void setPreviewCallback(Camera.PreviewCallback previewCallback) {
        this.mCamera.setPreviewCallback(previewCallback);
    }

    public int[] setPreviewResolution(int width, int height) {
        this.mCamera = this.openCamera();
        this.mPreviewWidth = width;
        this.mPreviewHeight = height;
        Camera camera = this.mCamera;
        camera.getClass();
        Camera.Size rs = this.adaptPreviewResolution(new Camera.Size(camera, width, height));
        if (rs != null) {
            this.mPreviewWidth = rs.width;
            this.mPreviewHeight = rs.height;
        }
        this.getHolder().setFixedSize(this.mPreviewWidth, this.mPreviewHeight);
        this.mCamera.getParameters().setPreviewSize(this.mPreviewWidth, this.mPreviewHeight);
        this.mGLPreviewBuffer = ByteBuffer.allocate(this.mPreviewWidth * this.mPreviewHeight * 4);
        return new int[]{this.mPreviewWidth, this.mPreviewHeight};
    }

    protected int getRotateDeg() {
        try {
            int rotate = ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getRotation();
            switch (rotate) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 90;
                }
                case 2: {
                    return 180;
                }
                case 3: {
                    return 270;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    public void setPreviewOrientation(int orientation) {
        this.mPreviewOrientation = orientation;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.mCamId, (Camera.CameraInfo)info);
        int rotateDeg = this.getRotateDeg();
        if (orientation == 1) {
            if (info.facing == 1) {
                this.mPreviewRotation = info.orientation % 360;
                this.mPreviewRotation = (360 - this.mPreviewRotation) % 360;
            } else {
                this.mPreviewRotation = (info.orientation + 360) % 360;
            }
        } else if (orientation == 2) {
            if (info.facing == 1) {
                this.mPreviewRotation = (info.orientation - 90) % 360;
                this.mPreviewRotation = (360 - this.mPreviewRotation) % 360;
            } else {
                this.mPreviewRotation = (info.orientation + 90) % 360;
            }
        }
        if (rotateDeg > 0) {
            this.mPreviewRotation %= rotateDeg;
        }
    }

    public int getCameraId() {
        return this.mCamId;
    }

    public void setCameraId(int id) {
        this.stopTorch();
        this.mCamId = id;
        this.setPreviewOrientation(this.mPreviewOrientation);
    }

    public void enableEncoding() {
        this.worker = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    while (!SrsCameraView.this.mGLIntBufferCache.isEmpty()) {
                        IntBuffer picture = (IntBuffer)SrsCameraView.this.mGLIntBufferCache.poll();
                        SrsCameraView.this.mGLPreviewBuffer.asIntBuffer().put(picture.array());
                        SrsCameraView.this.mPrevCb.onGetNV21Frame(SrsCameraView.this.mGLPreviewBuffer.array(), SrsCameraView.this.mPreviewWidth, SrsCameraView.this.mPreviewHeight);
                    }
                    Object object = SrsCameraView.this.writeLock;
                    synchronized (object) {
                        try {
                            SrsCameraView.this.writeLock.wait(500L);
                        }
                        catch (InterruptedException ie) {
                            SrsCameraView.this.worker.interrupt();
                        }
                    }
                }
            }
        });
        this.worker.start();
        this.mIsEncoding = true;
    }

    public void disableEncoding() {
        this.mIsEncoding = false;
        this.mGLIntBufferCache.clear();
        this.mGLPreviewBuffer.clear();
        if (this.worker != null) {
            this.worker.interrupt();
            try {
                this.worker.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.worker.interrupt();
            }
            this.worker = null;
        }
    }

    public boolean startCamera() {
        if (this.mCamera == null) {
            this.mCamera = this.openCamera();
            if (this.mCamera == null) {
                return false;
            }
        }
        Camera.Parameters params = this.mCamera.getParameters();
        params.setPreviewSize(this.mPreviewWidth, this.mPreviewHeight);
        int[] range = this.adaptFpsRange(24, params.getSupportedPreviewFpsRange());
        params.setPreviewFpsRange(range[0], range[1]);
        params.setPreviewFormat(17);
        params.setFlashMode("off");
        params.setWhiteBalance("auto");
        params.setSceneMode("auto");
        params.setRecordingHint(true);
        this.cameraCallbacksHandler.onCameraParameters(params);
        this.mCamera.setParameters(params);
        this.mCamera.setDisplayOrientation(this.mPreviewRotation);
        try {
            this.mCamera.setPreviewDisplay(this.getHolder());
            this.mCamera.setPreviewCallback((Camera.PreviewCallback)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mCamera.startPreview();
        return true;
    }

    public void stopCamera() {
        this.disableEncoding();
        this.stopTorch();
        if (this.mCamera != null) {
            this.mCamera.setPreviewCallback(null);
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    protected Camera openCamera() {
        Camera camera = null;
        if (this.mCamId < 0) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            int numCameras = Camera.getNumberOfCameras();
            int frontCamId = -1;
            int backCamId = -1;
            for (int i = 0; i < numCameras; ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (info.facing == 0) {
                    backCamId = i;
                    continue;
                }
                if (info.facing != 1) continue;
                frontCamId = i;
                break;
            }
            this.mCamId = frontCamId != -1 ? frontCamId : (backCamId != -1 ? backCamId : 0);
        }
        try {
            camera = Camera.open((int)this.mCamId);
            camera.setErrorCallback(new Camera.ErrorCallback(){

                public void onError(int error, Camera camera) {
                    SrsCameraView.this.stopCamera();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return camera;
    }

    private Camera.Size adaptPreviewResolution(Camera.Size resolution) {
        float diff = 100.0f;
        float xdy = (float)resolution.width / (float)resolution.height;
        Camera.Size best = null;
        for (Camera.Size size : this.mCamera.getParameters().getSupportedPreviewSizes()) {
            if (size.equals((Object)resolution)) {
                return size;
            }
            float tmp = Math.abs((float)size.width / (float)size.height - xdy);
            if (!(tmp < diff)) continue;
            diff = tmp;
            best = size;
        }
        return best;
    }

    private int[] adaptFpsRange(int expectedFps, List<int[]> fpsRanges) {
        int[] closestRange = fpsRanges.get(0);
        int measure = Math.abs(closestRange[0] - (expectedFps *= 1000)) + Math.abs(closestRange[1] - expectedFps);
        for (int[] range : fpsRanges) {
            int curMeasure;
            if (range[0] > expectedFps || range[1] < expectedFps || (curMeasure = Math.abs(range[0] - expectedFps) + Math.abs(range[1] - expectedFps)) >= measure) continue;
            closestRange = range;
            measure = curMeasure;
        }
        return closestRange;
    }

    public boolean startTorch() {
        Camera.Parameters params;
        List supportedFlashModes;
        if (this.mCamera != null && (supportedFlashModes = (params = this.mCamera.getParameters()).getSupportedFlashModes()) != null && !supportedFlashModes.isEmpty() && supportedFlashModes.contains("torch")) {
            params.setFlashMode("torch");
            this.mCamera.setParameters(params);
            return true;
        }
        return false;
    }

    public void stopTorch() {
        if (this.mCamera != null) {
            try {
                Camera.Parameters params = this.mCamera.getParameters();
                params.setFlashMode("off");
                this.mCamera.setParameters(params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        YuvImage yuv = new YuvImage(data, camera.getParameters().getPreviewFormat(), camera.getParameters().getPreviewSize().width, camera.getParameters().getPreviewSize().height, null);
        this.mGLPreviewBuffer.asIntBuffer().put(this.convertData2IntBuffer(yuv.getYuvData()));
        this.mPrevCb.onGetNV21Frame(this.mGLPreviewBuffer.array(), yuv.getWidth(), yuv.getHeight());
    }

    private IntBuffer convertData2IntBuffer(byte[] data) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.rewind();
        IntBuffer ib = ((ByteBuffer)bb.rewind()).asIntBuffer();
        return ib;
    }

    public void setCameraCallbacksHandler(CameraCallbacksHandler cameraCallbacksHandler) {
        this.cameraCallbacksHandler = cameraCallbacksHandler;
    }

    public static class CameraCallbacksHandler
    implements CameraCallbacks {
        @Override
        public void onCameraParameters(Camera.Parameters params) {
        }
    }

    public static interface CameraCallbacks {
        public void onCameraParameters(Camera.Parameters var1);
    }

    public static interface PreviewCallback {
        public void onGetNV21Frame(byte[] var1, int var2, int var3);
    }
}

