/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.ultraviolet;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class BaseLocationBox
extends AbstractFullBox {
    String baseLocation = "";
    String purchaseLocation = "";

    public BaseLocationBox() {
        super("bloc");
    }

    public BaseLocationBox(String baseLocation, String purchaseLocation) {
        super("bloc");
        this.baseLocation = baseLocation;
        this.purchaseLocation = purchaseLocation;
    }

    public String getBaseLocation() {
        return this.baseLocation;
    }

    public void setBaseLocation(String baseLocation) {
        this.baseLocation = baseLocation;
    }

    public String getPurchaseLocation() {
        return this.purchaseLocation;
    }

    public void setPurchaseLocation(String purchaseLocation) {
        this.purchaseLocation = purchaseLocation;
    }

    @Override
    protected long getContentSize() {
        return 1028L;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.baseLocation = IsoTypeReader.readString(content);
        content.get(new byte[256 - Utf8.utf8StringLengthInBytes(this.baseLocation) - 1]);
        this.purchaseLocation = IsoTypeReader.readString(content);
        content.get(new byte[256 - Utf8.utf8StringLengthInBytes(this.purchaseLocation) - 1]);
        content.get(new byte[512]);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.put(Utf8.convert(this.baseLocation));
        byteBuffer.put(new byte[256 - Utf8.utf8StringLengthInBytes(this.baseLocation)]);
        byteBuffer.put(Utf8.convert(this.purchaseLocation));
        byteBuffer.put(new byte[256 - Utf8.utf8StringLengthInBytes(this.purchaseLocation)]);
        byteBuffer.put(new byte[512]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseLocationBox that = (BaseLocationBox)o;
        if (this.baseLocation != null ? !this.baseLocation.equals(that.baseLocation) : that.baseLocation != null) {
            return false;
        }
        return !(this.purchaseLocation != null ? !this.purchaseLocation.equals(that.purchaseLocation) : that.purchaseLocation != null);
    }

    public int hashCode() {
        int result = this.baseLocation != null ? this.baseLocation.hashCode() : 0;
        result = 31 * result + (this.purchaseLocation != null ? this.purchaseLocation.hashCode() : 0);
        return result;
    }
}

