/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.io;

import com.github.faucamp.simplertmp.io.ChunkStreamInfo;
import com.github.faucamp.simplertmp.io.WindowAckRequired;
import com.github.faucamp.simplertmp.io.packets.RtmpPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RtmpSessionInfo {
    private int windowBytesRead;
    private int acknowledgementWindowSize = Integer.MAX_VALUE;
    private int totalBytesRead = 0;
    private int rxChunkSize = 128;
    private int txChunkSize = 128;
    private Map<Integer, ChunkStreamInfo> chunkChannels = new HashMap<Integer, ChunkStreamInfo>();
    private Map<Integer, String> invokedMethods = new ConcurrentHashMap<Integer, String>();

    public ChunkStreamInfo getChunkStreamInfo(int chunkStreamId) {
        ChunkStreamInfo chunkStreamInfo = this.chunkChannels.get(chunkStreamId);
        if (chunkStreamInfo == null) {
            chunkStreamInfo = new ChunkStreamInfo();
            this.chunkChannels.put(chunkStreamId, chunkStreamInfo);
        }
        return chunkStreamInfo;
    }

    public String takeInvokedCommand(int transactionId) {
        return this.invokedMethods.remove(transactionId);
    }

    public String addInvokedCommand(int transactionId, String commandName) {
        return this.invokedMethods.put(transactionId, commandName);
    }

    public int getRxChunkSize() {
        return this.rxChunkSize;
    }

    public void setRxChunkSize(int chunkSize) {
        this.rxChunkSize = chunkSize;
    }

    public int getTxChunkSize() {
        return this.txChunkSize;
    }

    public void setTxChunkSize(int chunkSize) {
        this.txChunkSize = chunkSize;
    }

    public int getAcknowledgementWindowSize() {
        return this.acknowledgementWindowSize;
    }

    public void setAcknowledgmentWindowSize(int acknowledgementWindowSize) {
        this.acknowledgementWindowSize = acknowledgementWindowSize;
    }

    public final void addToWindowBytesRead(int numBytes, RtmpPacket packet) throws WindowAckRequired {
        this.windowBytesRead += numBytes;
        this.totalBytesRead += numBytes;
        if (this.windowBytesRead >= this.acknowledgementWindowSize) {
            this.windowBytesRead -= this.acknowledgementWindowSize;
            throw new WindowAckRequired(this.totalBytesRead, packet);
        }
    }
}

