/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.amf;

import java.util.HashMap;
import java.util.Map;

public enum AmfType {
    NUMBER(0),
    BOOLEAN(1),
    STRING(2),
    OBJECT(3),
    NULL(5),
    MAP(8),
    ARRAY(10);

    private static final Map<Byte, AmfType> quickLookupMap;
    private byte value;

    private AmfType(int intValue) {
        this.value = (byte)intValue;
    }

    public static AmfType valueOf(byte amfTypeByte) {
        return quickLookupMap.get(amfTypeByte);
    }

    public byte getValue() {
        return this.value;
    }

    static {
        quickLookupMap = new HashMap<Byte, AmfType>();
        for (AmfType amfType : AmfType.values()) {
            quickLookupMap.put(amfType.getValue(), amfType);
        }
    }
}

