/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public final class OmaDrmAccessUnitFormatBox
extends AbstractFullBox {
    public static final String TYPE = "odaf";
    private boolean selectiveEncryption;
    private byte allBits;
    private int keyIndicatorLength;
    private int initVectorLength;

    public OmaDrmAccessUnitFormatBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 7L;
    }

    public boolean isSelectiveEncryption() {
        return this.selectiveEncryption;
    }

    public int getKeyIndicatorLength() {
        return this.keyIndicatorLength;
    }

    public void setKeyIndicatorLength(int keyIndicatorLength) {
        this.keyIndicatorLength = keyIndicatorLength;
    }

    public int getInitVectorLength() {
        return this.initVectorLength;
    }

    public void setInitVectorLength(int initVectorLength) {
        this.initVectorLength = initVectorLength;
    }

    public void setAllBits(byte allBits) {
        this.allBits = allBits;
        this.selectiveEncryption = (allBits & 0x80) == 128;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.allBits = (byte)IsoTypeReader.readUInt8(content);
        this.selectiveEncryption = (this.allBits & 0x80) == 128;
        this.keyIndicatorLength = IsoTypeReader.readUInt8(content);
        this.initVectorLength = IsoTypeReader.readUInt8(content);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt8(byteBuffer, this.allBits);
        IsoTypeWriter.writeUInt8(byteBuffer, this.keyIndicatorLength);
        IsoTypeWriter.writeUInt8(byteBuffer, this.initVectorLength);
    }
}

